/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.handler.DefaultWebSocketRequestHandler;
import com.ly.doc.handler.IWebSocketRequestHandler;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.WebSocketDoc;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.annotation.ServerEndpointAnnotation;
import com.ly.doc.model.request.ServerEndpoint;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.ValidateUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public interface IWebSocketTemplate {
    public static final AtomicInteger ATOMIC_INTEGER = new AtomicInteger(1);

    default public List<WebSocketDoc> processWebSocketData(ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations, IWebSocketRequestHandler webSocketRequestHandler, Collection<JavaClass> candidateClasses) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        ArrayList<WebSocketDoc> apiDocList = new ArrayList<WebSocketDoc>();
        int maxOrder = 0;
        boolean setCustomOrder = false;
        for (JavaClass javaClass : candidateClasses) {
            WebSocketDoc webSocketDoc;
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), javaClass) || StringUtil.isNotEmpty((String)apiConfig.getPackageExcludeFilters()) && DocUtil.isMatch(apiConfig.getPackageExcludeFilters(), javaClass) || Objects.nonNull(javaClass.getTagByName("ignore"))) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(javaClass, "order", Boolean.TRUE);
            int order = 0;
            if (ValidateUtil.isNonNegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
                maxOrder = Math.max(maxOrder, order);
            }
            if (!Objects.nonNull(webSocketDoc = this.buildEntryPointWebSocketDoc(javaClass, apiConfig, webSocketRequestHandler, frameworkAnnotations, order))) continue;
            apiDocList.add(webSocketDoc);
        }
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            ATOMIC_INTEGER.getAndAdd(maxOrder);
            ArrayList<WebSocketDoc> tempList = new ArrayList<WebSocketDoc>(apiDocList);
            tempList.forEach(p -> {
                if (p.getOrder() == 0) {
                    p.setOrder(ATOMIC_INTEGER.getAndAdd(1));
                }
            });
            return tempList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).collect(Collectors.toList());
        }
        return apiDocList;
    }

    default public WebSocketDoc buildEntryPointWebSocketDoc(JavaClass javaClass, ApiConfig apiConfig, IWebSocketRequestHandler webSocketRequestHandler, FrameworkAnnotations frameworkAnnotations, int order) {
        List<ApiParam> apiParamList;
        Optional<JavaAnnotation> optionalAnnotation = this.getOptionalWebSocketAnnotation(javaClass, frameworkAnnotations);
        if (!optionalAnnotation.isPresent()) {
            return null;
        }
        webSocketRequestHandler = webSocketRequestHandler == null ? DefaultWebSocketRequestHandler.getInstance() : webSocketRequestHandler;
        ServerEndpoint serverEndpoint = webSocketRequestHandler.handleServerEndpoint(javaClass, optionalAnnotation.get());
        WebSocketDoc webSocketDoc = new WebSocketDoc();
        if (!serverEndpoint.getSubProtocols().isEmpty()) {
            webSocketDoc.setSubProtocols(String.join((CharSequence)",", serverEndpoint.getSubProtocols()));
        }
        if (!(apiParamList = this.getApiParamList(javaClass, serverEndpoint)).isEmpty()) {
            webSocketDoc.setPathParams(apiParamList);
        }
        webSocketDoc.setName(javaClass.getName());
        webSocketDoc.setUrl(IWebSocketTemplate.replaceHttpPrefixToWebSocketPrefix(apiConfig.getServerUrl()) + serverEndpoint.getUrl());
        webSocketDoc.setPackageName(javaClass.getPackage().getName());
        webSocketDoc.setDesc(DocUtil.getEscapeAndCleanComment(javaClass.getComment()));
        webSocketDoc.setAuthor(JavaClassUtil.getClassTagsValue(javaClass, "author", Boolean.TRUE));
        webSocketDoc.setOrder(order);
        boolean isDeprecated = Objects.nonNull(javaClass.getTagByName("deprecated")) || javaClass.getAnnotations().stream().anyMatch(i -> "java.lang.Deprecated".equals(i.getType().getGenericFullyQualifiedName()));
        webSocketDoc.setDeprecated(isDeprecated);
        return webSocketDoc;
    }

    default public Optional<JavaAnnotation> getOptionalWebSocketAnnotation(JavaClass javaClass, FrameworkAnnotations frameworkAnnotations) {
        if (null == frameworkAnnotations || null == javaClass || null == frameworkAnnotations.getServerEndpointAnnotation()) {
            return Optional.empty();
        }
        ServerEndpointAnnotation serverEndpointAnnotation = frameworkAnnotations.getServerEndpointAnnotation();
        return javaClass.getAnnotations().stream().filter(annotation -> Objects.equals(serverEndpointAnnotation.getAnnotationName(), annotation.getType().getName())).findFirst();
    }

    default public List<ApiParam> getApiParamList(JavaClass javaClass, ServerEndpoint serverEndpoint) {
        ArrayList<ApiParam> pathParams = new ArrayList<ApiParam>();
        String url = serverEndpoint.getUrl();
        Set<String> pathParamsSet = IWebSocketTemplate.parsePathParams(url);
        if (pathParamsSet.isEmpty()) {
            return pathParams;
        }
        HashMap<String, JavaParameter> parameterMap = new HashMap<String, JavaParameter>(16);
        Map<Object, Object> commentsByTag = new HashMap(16);
        for (JavaMethod javaMethod : javaClass.getMethods()) {
            boolean hasOnOpenAnnotation = javaMethod.getAnnotations().stream().anyMatch(annotation -> "OnOpen".equals(annotation.getType().getName()));
            if (!hasOnOpenAnnotation) continue;
            List parameters = javaMethod.getParameters();
            for (JavaParameter parameter : parameters) {
                commentsByTag = DocUtil.getCommentsByTag(javaMethod, "param", javaClass.getName());
                for (JavaAnnotation annotation2 : parameter.getAnnotations()) {
                    if (!"PathParam".equals(annotation2.getType().getName())) continue;
                    parameterMap.put(parameter.getName(), parameter);
                }
            }
        }
        for (String item : pathParamsSet) {
            ApiParam pathApiParam = ApiParam.of().setId(0).setField(item).setType("string").setDesc(item).setVersion(null == commentsByTag.get("since") ? "-" : (String)commentsByTag.get("since")).setRequired(true);
            JavaParameter javaParameter = (JavaParameter)parameterMap.get(item);
            if (null != javaParameter) {
                pathApiParam.setType(DocClassUtil.processTypeNameForParams(javaParameter.getType().getGenericFullyQualifiedName())).setDesc((String)commentsByTag.get(javaParameter.getName()));
            }
            pathParams.add(pathApiParam);
        }
        return pathParams;
    }

    public static Set<String> parsePathParams(String url) {
        String[] urlParts;
        LinkedHashSet<String> pathParams = new LinkedHashSet<String>();
        for (String item : urlParts = url.split("/")) {
            if (!item.startsWith("{") || !item.endsWith("}") || item.length() <= 2) continue;
            String paramName = item.substring(1, item.length() - 1);
            pathParams.add(paramName);
        }
        return pathParams;
    }

    public static String replaceHttpPrefixToWebSocketPrefix(String url) {
        return url.replaceAll("http://", "ws://").replaceAll("https://", "wss://");
    }
}

