/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.constants.MediaType;
import com.ly.doc.handler.DefaultWebSocketRequestHandler;
import com.ly.doc.handler.IHeaderHandler;
import com.ly.doc.handler.IRequestMappingHandler;
import com.ly.doc.handler.JaxrsHeaderHandler;
import com.ly.doc.handler.JaxrsPathHandler;
import com.ly.doc.handler.SpringMVCRequestHeaderHandler;
import com.ly.doc.handler.SpringMVCRequestMappingHandler;
import com.ly.doc.helper.FormDataBuildHelper;
import com.ly.doc.helper.JsonBuildHelper;
import com.ly.doc.helper.ParamsBuildHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiExceptionStatus;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.ApiMethodReqParam;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.DocJavaMethod;
import com.ly.doc.model.DocJavaParameter;
import com.ly.doc.model.ExceptionAdviceMethod;
import com.ly.doc.model.FormData;
import com.ly.doc.model.WebSocketDoc;
import com.ly.doc.model.annotation.EntryAnnotation;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.annotation.HeaderAnnotation;
import com.ly.doc.model.request.ApiRequestExample;
import com.ly.doc.model.request.CurlRequest;
import com.ly.doc.model.request.JaxrsPathMapping;
import com.ly.doc.model.request.RequestMapping;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.template.IRestDocTemplate;
import com.ly.doc.template.IWebSocketDocBuildTemplate;
import com.ly.doc.template.IWebSocketTemplate;
import com.ly.doc.utils.ApiParamTreeUtil;
import com.ly.doc.utils.CurlUtil;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocPathUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.ly.doc.utils.JavaFieldUtil;
import com.ly.doc.utils.JsonUtil;
import com.ly.doc.utils.RequestExampleUtil;
import com.ly.doc.utils.TornaUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JAXRSDocBuildTemplate
implements IDocBuildTemplate<ApiDoc>,
IWebSocketDocBuildTemplate<WebSocketDoc>,
IRestDocTemplate,
IWebSocketTemplate {
    private static final Logger log = Logger.getLogger(JAXRSDocBuildTemplate.class.getName());
    private List<ApiReqParam> headers;

    @Override
    public boolean supportsFramework(String framework) {
        return FrameworkEnum.JAX_RS.getFramework().equalsIgnoreCase(framework);
    }

    @Override
    public ApiSchema<ApiDoc> renderApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        this.headers = apiConfig.getRequestHeaders();
        List<ApiReqParam> configApiReqParams = Stream.of(apiConfig.getRequestHeaders(), apiConfig.getRequestParams()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        FrameworkAnnotations frameworkAnnotations = this.registeredAnnotations();
        return this.processApiData(projectBuilder, frameworkAnnotations, configApiReqParams, new SpringMVCRequestMappingHandler(), new SpringMVCRequestHeaderHandler(), candidateClasses);
    }

    @Override
    public List<ApiMethodDoc> buildEntryPointMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations, List<ApiReqParam> configApiReqParams, IRequestMappingHandler baseMappingHandler, IHeaderHandler headerHandler) {
        return this.buildControllerMethod(cls, apiConfig, projectBuilder, frameworkAnnotations);
    }

    @Override
    public List<WebSocketDoc> renderWebSocketApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        FrameworkAnnotations frameworkAnnotations = this.registeredAnnotations();
        return this.processWebSocketData(projectBuilder, frameworkAnnotations, DefaultWebSocketRequestHandler.getInstance(), candidateClasses);
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations) {
        String clzName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        String group = JavaClassUtil.getClassTagsValue(cls, "group", Boolean.TRUE);
        String baseUrl = "";
        String mediaType = "application/x-www-form-urlencoded";
        List<JavaAnnotation> classAnnotations = this.getClassAnnotations(cls, frameworkAnnotations);
        for (JavaAnnotation annotation : classAnnotations) {
            Object value;
            String annotationName = annotation.getType().getFullyQualifiedName();
            if ("jakarta.ws.rs.Path".equals(annotationName) || "javax.ws.rs.Path".equals(annotationName)) {
                ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
                baseUrl = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(classLoader, annotation));
            }
            if (!annotationName.equals("jakarta.ws.rs.Consumes") && !annotationName.equals("javax.ws.rs.Consumes") || !Objects.nonNull(value = annotation.getNamedParameter("value"))) continue;
            mediaType = MediaType.valueOf(value.toString());
        }
        Set<String> filterMethods = DocUtil.findFilterMethods(clzName);
        boolean needAllMethods = filterMethods.contains("*");
        List methods = cls.getMethods();
        ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
        for (JavaMethod method : methods) {
            if (method.isPrivate() || !needAllMethods && !filterMethods.contains(method.getName())) continue;
            docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, method, null));
        }
        docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, projectBuilder, cls));
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (DocJavaMethod docJavaMethod : docJavaMethods) {
            JaxrsPathMapping jaxPathMapping;
            JavaMethod method = docJavaMethod.getJavaMethod();
            if (this.checkCondition(method) || Objects.isNull(jaxPathMapping = new JaxrsPathHandler().handle(projectBuilder, baseUrl, method, mediaType))) continue;
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            apiMethodDoc.setDownload(docJavaMethod.isDownload());
            apiMethodDoc.setPage(docJavaMethod.getPage());
            apiMethodDoc.setGroup(group);
            if (Objects.nonNull(docJavaMethod.getGroup())) {
                apiMethodDoc.setGroup(docJavaMethod.getGroup());
            }
            apiMethodDoc.setName(method.getName());
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setDesc(docJavaMethod.getDesc());
            String methodUid = DocUtil.generateId(clzName + method.getName() + methodOrder);
            apiMethodDoc.setMethodId(methodUid);
            apiMethodDoc.setAuthor(docJavaMethod.getAuthor());
            apiMethodDoc.setDetail(docJavaMethod.getDetail());
            List<ApiReqParam> apiReqParams = new JaxrsHeaderHandler().handle(method, projectBuilder);
            apiMethodDoc.setType(jaxPathMapping.getMethodType());
            apiMethodDoc.setUrl(jaxPathMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(jaxPathMapping.getShortUrl());
            apiMethodDoc.setDeprecated(jaxPathMapping.isDeprecated());
            apiMethodDoc.setContentType(jaxPathMapping.getMediaType());
            ApiMethodReqParam apiMethodReqParam = this.requestParams(docJavaMethod, projectBuilder);
            apiMethodDoc.setPathParams(apiMethodReqParam.getPathParams());
            apiMethodDoc.setQueryParams(apiMethodReqParam.getQueryParams());
            apiMethodDoc.setRequestParams(apiMethodReqParam.getRequestParams());
            if (paramsDataToTree) {
                this.convertParamsDataToTree(apiMethodDoc);
            }
            List<ApiReqParam> allApiReqParams = apiReqParams;
            if (Objects.nonNull(this.headers)) {
                allApiReqParams = Stream.of(this.headers, apiReqParams).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
            allApiReqParams.removeIf(apiReqParam -> {
                if (StringUtil.isEmpty((String)apiReqParam.getPathPatterns()) && StringUtil.isEmpty((String)apiReqParam.getExcludePathPatterns())) {
                    return false;
                }
                boolean flag = DocPathUtil.matches(jaxPathMapping.getShortUrl(), apiReqParam.getPathPatterns(), apiReqParam.getExcludePathPatterns());
                return !flag;
            });
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqParams, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqParams);
            ApiRequestExample requestExample = this.buildReqJson(docJavaMethod, apiMethodDoc, projectBuilder);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
            if (StringUtil.isNotEmpty((String)responseValue)) {
                apiMethodDoc.setResponseUsage(responseValue);
            } else {
                apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
            }
            List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
            }
            apiMethodDoc.setReturnSchema(docJavaMethod.getReturnSchema());
            apiMethodDoc.setRequestSchema(docJavaMethod.getRequestSchema());
            apiMethodDoc.setResponseParams(responseParams);
            methodDocList.add(apiMethodDoc);
            TornaUtil.setTornaArrayTags(docJavaMethod.getJavaMethod(), apiMethodDoc, apiConfig);
        }
        return methodDocList;
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        FrameworkAnnotations annotations = FrameworkAnnotations.builder();
        HeaderAnnotation headerAnnotation = HeaderAnnotation.builder().setAnnotationName("javax.ws.rs.HeaderParam").setValueProp("value").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setHeaderAnnotation(headerAnnotation);
        HashMap<String, EntryAnnotation> entryAnnotations = new HashMap<String, EntryAnnotation>(16);
        EntryAnnotation jakartaPathAnnotation = EntryAnnotation.builder().setAnnotationName("jakarta.ws.rs.Path").setAnnotationFullyName("jakarta.ws.rs.Path");
        entryAnnotations.put(jakartaPathAnnotation.getAnnotationName(), jakartaPathAnnotation);
        EntryAnnotation jaxPathAnnotation = EntryAnnotation.builder().setAnnotationName("javax.ws.rs.Path").setAnnotationFullyName("javax.ws.rs.Path");
        entryAnnotations.put(jaxPathAnnotation.getAnnotationName(), jaxPathAnnotation);
        annotations.setEntryAnnotations(entryAnnotations);
        return annotations;
    }

    @Override
    public boolean isEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        boolean isDefaultEntryPoint = this.defaultEntryPoint(cls, frameworkAnnotations);
        if (isDefaultEntryPoint) {
            return true;
        }
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        List<JavaAnnotation> classAnnotations = DocClassUtil.getAnnotations(cls);
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getFullyQualifiedName();
            if (!"jakarta.ws.rs.Path".equals(annotationName) && !"javax.ws.rs.Path".equals(annotationName)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"dubboRest".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> listMvcRequestAnnotations() {
        return null;
    }

    private ApiMethodReqParam requestParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder) {
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        List<DocJavaParameter> parameterList = this.getJavaParameterList(builder, docJavaMethod, null);
        if (parameterList.isEmpty()) {
            return ApiMethodReqParam.builder().setPathParams(new ArrayList<ApiParam>(0)).setQueryParams(paramList).setRequestParams(new ArrayList<ApiParam>(0));
        }
        boolean isStrict = builder.getApiConfig().isStrict();
        boolean isShowValidation = builder.getApiConfig().isShowValidation();
        ClassLoader classLoader = builder.getApiConfig().getClassLoader();
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = docJavaMethod.getParamTagMap();
        Map<String, String> paramsComments = docJavaMethod.getParamsComments();
        Map<String, String> constantsMap = builder.getConstantsMap();
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        Set<String> ignoreSets = this.ignoreParamsSets(javaMethod);
        block0: for (DocJavaParameter apiParameter : parameterList) {
            ApiParam param;
            String[] gicNameArr;
            boolean queryParam;
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            if (ignoreSets.contains(paramName)) continue;
            String typeName = apiParameter.getGenericCanonicalName();
            String simpleName = apiParameter.getTypeValue().toLowerCase();
            String fullyQualifiedName = apiParameter.getFullyQualifiedName();
            String genericFullyQualifiedName = apiParameter.getGenericFullyQualifiedName();
            String simpleTypeName = apiParameter.getTypeValue();
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(genericFullyQualifiedName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @QueryParam for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(genericFullyQualifiedName);
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, builder.getJavaProjectBuilder());
            StringBuilder comment = new StringBuilder(this.paramCommentResolve(paramTagMap.get(paramName)));
            boolean isPathVariable = false;
            boolean isRequestBody = false;
            String strRequired = "false";
            if (CollectionUtil.isNotEmpty((Collection)annotations)) {
                for (JavaAnnotation annotation : annotations) {
                    String annotationName = annotation.getType().getFullyQualifiedName();
                    if ("jakarta.ws.rs.HeaderParam".equals(annotationName) || "javax.ws.rs.HeaderParam".equals(annotationName)) continue block0;
                    if ("jakarta.ws.rs.DefaultValue".equals(annotationName) || "javax.ws.rs.DefaultValue".equals(annotationName)) {
                        mockValue = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(classLoader, annotation));
                        mockValue = DocUtil.handleConstants(constantsMap, mockValue);
                    }
                    if ("jakarta.ws.rs.PathParam".equals(annotationName) || "org.jboss.resteasy.reactive.RestPath".equals(annotationName) || "javax.ws.rs.PathParam".equals(annotationName)) {
                        isPathVariable = true;
                        strRequired = "true";
                    }
                    if (!JavaClassValidateUtil.isJSR303Required(annotation.getType().getValue())) continue;
                    strRequired = "true";
                }
                comment.append(JavaFieldUtil.getJsrComment(isShowValidation, classLoader, annotations));
            } else {
                isRequestBody = true;
            }
            boolean required = Boolean.parseBoolean(strRequired);
            boolean bl = queryParam = !isRequestBody && !isPathVariable;
            if (JavaClassValidateUtil.isCollection(fullyQualifiedName) || JavaClassValidateUtil.isArray(fullyQualifiedName)) {
                ApiParam param2;
                JavaClass gicJavaClass;
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                String gicName = gicNameArr[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if ((gicJavaClass = builder.getJavaProjectBuilder().getClassByName(gicName)).isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(gicJavaClass, Boolean.TRUE);
                    param2 = ApiParam.of().setField(paramName).setDesc(comment + ",[array of enum]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(String.valueOf(value));
                    paramList.add(param2);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams(gicName);
                    param2 = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(DocUtil.getValByTypeAndFieldName(gicName, paramName));
                    paramList.add(param2);
                    continue;
                }
                int id = paramList.size() + 1;
                param2 = ApiParam.of().setField(paramName).setDesc(comment + ",[array of object]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(id).setType("array");
                paramList.add(param2);
                List<ApiParam> apiParamList = ParamsBuildHelper.buildParams(typeName, "\u2514\u2500", 1, "true", Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, id, Boolean.FALSE, null);
                paramList.addAll(apiParamList);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullyQualifiedName)) {
                param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(mockValue).setDesc(comment.toString()).setRequired(required).setVersion("-");
                paramList.add(param);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullyQualifiedName)) {
                log.warning("When using smart-doc, it is not recommended to use Map to receive parameters, Check it in " + javaMethod.getDeclaringClass().getCanonicalName() + "#" + javaMethod.getName());
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                if (JavaClassValidateUtil.isPrimitive(gicNameArr[1])) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, "true", Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.FALSE, null));
                continue;
            }
            if (JavaClassValidateUtil.isFile(typeName)) {
                param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(required).setVersion("-").setDesc(comment.toString());
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment.append("(array of file)");
                    param.setDesc(comment.toString());
                    param.setHasItems(true);
                }
                paramList.add(param);
                continue;
            }
            if (javaClass.isEnum()) {
                String o = JavaClassUtil.getEnumParams(javaClass);
                Object value = JavaClassUtil.getEnumValue(javaClass, true);
                ApiParam param3 = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(String.valueOf(value)).setType("enum").setDesc(StringUtil.removeQuotes((String)o)).setRequired(required).setVersion("-").setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                paramList.add(param3);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, "", 0, "true", Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.FALSE, null));
        }
        ArrayList<ApiParam> pathParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> queryParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> bodyParams = new ArrayList<ApiParam>();
        for (ApiParam param : paramList) {
            param.setValue(StringUtil.removeDoubleQuotes((String)param.getValue()));
            if (param.isPathParam()) {
                param.setId(pathParams.size() + 1);
                pathParams.add(param);
                continue;
            }
            if (param.isQueryParam()) {
                param.setId(queryParams.size() + 1);
                queryParams.add(param);
                continue;
            }
            param.setId(bodyParams.size() + 1);
            bodyParams.add(param);
        }
        return ApiMethodReqParam.builder().setRequestParams(bodyParams).setPathParams(pathParams).setQueryParams(queryParams);
    }

    private ApiRequestExample buildReqJson(DocJavaMethod javaMethod, ApiMethodDoc apiMethodDoc, ProjectDocConfigBuilder configBuilder) {
        String methodType = apiMethodDoc.getType();
        JavaMethod method = javaMethod.getJavaMethod();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        List<DocJavaParameter> parameterList = this.getJavaParameterList(configBuilder, javaMethod, null);
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        if (parameterList.isEmpty()) {
            CurlRequest curlRequest = CurlRequest.builder().setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(apiMethodDoc.getUrl());
            String format = CurlUtil.toCurl(curlRequest);
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map<String, String> paramsComments = javaMethod.getParamsComments();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        for (DocJavaParameter apiParameter : parameterList) {
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            String typeName = apiParameter.getGenericFullyQualifiedName();
            String fullyQualifiedName = apiParameter.getFullyQualifiedName();
            String gicTypeName = apiParameter.getGenericCanonicalName();
            String simpleTypeName = apiParameter.getTypeValue();
            gicTypeName = DocClassUtil.rewriteRequestParam(gicTypeName);
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicTypeName, simpleTypeName);
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, configBuilder.getJavaProjectBuilder());
            boolean paramAdded = false;
            if (CollectionUtil.isNotEmpty((Collection)annotations)) {
                for (JavaAnnotation annotation : annotations) {
                    FormData formData;
                    Object value;
                    String annotationName = annotation.getType().getFullyQualifiedName();
                    if ("jakarta.ws.rs.PathParam".equals(annotationName) || "org.jboss.resteasy.reactive.RestPath".equals(annotationName) || "javax.ws.rs.PathParam".equals(annotationName)) {
                        if (javaClass.isEnum()) {
                            value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                            mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                        }
                        pathParamsMap.put(paramName, mockValue);
                        paramAdded = true;
                    }
                    if (paramAdded) continue;
                    if (JavaClassValidateUtil.isFile(gicTypeName)) {
                        apiMethodDoc.setContentType("multipart/form-data");
                        formData = new FormData();
                        formData.setKey(paramName);
                        formData.setType("file");
                        formData.setDescription(comment);
                        formData.setValue(mockValue);
                        formDataList.add(formData);
                        continue;
                    }
                    if (JavaClassValidateUtil.isPrimitive(fullyQualifiedName)) {
                        formData = new FormData();
                        formData.setKey(paramName);
                        formData.setDescription(comment);
                        formData.setType("text");
                        formData.setValue(mockValue);
                        formDataList.add(formData);
                        continue;
                    }
                    if (JavaClassValidateUtil.isArray(fullyQualifiedName) || JavaClassValidateUtil.isCollection(fullyQualifiedName)) {
                        String gicName = globGicName[0];
                        if (JavaClassValidateUtil.isArray(gicName)) {
                            gicName = gicName.substring(0, gicName.indexOf("["));
                        }
                        if (!JavaClassValidateUtil.isPrimitive(gicName) && !configBuilder.getJavaProjectBuilder().getClassByName(gicName).isEnum()) {
                            throw new RuntimeException("Jaxrs rest can't support binding Collection on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                        }
                        FormData formData2 = new FormData();
                        formData2.setKey(paramName);
                        if (!paramName.contains("[]")) {
                            formData2.setKey(paramName + "[]");
                        }
                        formData2.setDescription(comment);
                        formData2.setType("text");
                        formData2.setValue(RandomUtil.randomValueByType((String)gicName));
                        formDataList.add(formData2);
                        continue;
                    }
                    if (javaClass.isEnum()) {
                        value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                        String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                        FormData formData3 = new FormData();
                        formData3.setDescription(comment);
                        formData3.setKey(paramName);
                        formData3.setType("text");
                        formData3.setValue(strVal);
                        formDataList.add(formData3);
                        continue;
                    }
                    formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(16), 0, configBuilder, "", groupClasses));
                }
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                requestExample.setJsonBody(mockValue).setJson(true);
                continue;
            }
            String json = JsonBuildHelper.buildJson(fullyQualifiedName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(16), groupClasses, configBuilder);
            requestExample.setJsonBody(JsonUtil.toPrettyFormat(json)).setJson(true);
        }
        requestExample.setFormDataList(formDataList);
        RequestExampleUtil.setExampleBody(apiMethodDoc, requestExample, formDataList, pathParamsMap, pathParamsMap);
        return requestExample;
    }

    private boolean checkCondition(JavaMethod method) {
        return method.isPrivate() || Objects.nonNull(method.getTagByName("ignore"));
    }

    @Override
    public void requestMappingPostProcess(JavaClass javaClass, JavaMethod method, RequestMapping requestMapping) {
    }

    @Override
    public boolean ignoreMvcParamWithAnnotation(String annotation) {
        return false;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return false;
    }

    @Override
    public boolean isExceptionAdviceEntryPoint(JavaClass javaClass, FrameworkAnnotations frameworkAnnotations) {
        return false;
    }

    @Override
    public ExceptionAdviceMethod processExceptionAdviceMethod(JavaMethod method) {
        return null;
    }

    @Override
    public List<ApiExceptionStatus> defaultHttpErrorStatuses() {
        return null;
    }
}

