/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.JavadocJavaMethod;
import com.ly.doc.model.WebSocketDoc;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.javadoc.JavadocApiDoc;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.template.IJavadocDocTemplate;
import com.ly.doc.template.IWebSocketDocBuildTemplate;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.ValidateUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class JavadocDocBuildTemplate
implements IDocBuildTemplate<JavadocApiDoc>,
IWebSocketDocBuildTemplate<WebSocketDoc>,
IJavadocDocTemplate {
    private final AtomicInteger ATOMIC_INTEGER = new AtomicInteger(1);

    @Override
    public boolean supportsFramework(String framework) {
        return FrameworkEnum.JAVADOC.getFramework().equalsIgnoreCase(framework);
    }

    @Override
    public boolean addMethodModifiers() {
        return true;
    }

    @Override
    public ApiSchema<JavadocApiDoc> renderApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        ArrayList<JavadocApiDoc> apiDocList = new ArrayList<JavadocApiDoc>();
        int maxOrder = 0;
        boolean setCustomOrder = false;
        for (JavaClass cls : candidateClasses) {
            if (this.skipClass(apiConfig, cls, null)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            int order = 0;
            if (ValidateUtil.isNonNegativeInteger((String)strOrder)) {
                order = Integer.parseInt(strOrder);
                maxOrder = Math.max(maxOrder, order);
                setCustomOrder = true;
            }
            List<JavadocJavaMethod> apiMethodDocs = this.buildServiceMethod(cls, apiConfig, projectBuilder);
            this.handleJavaApiDoc(cls, apiDocList, apiMethodDocs, order, projectBuilder);
        }
        ApiSchema<JavadocApiDoc> apiSchema = new ApiSchema<JavadocApiDoc>();
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
            apiSchema.setApiDatas(apiDocList);
            return apiSchema;
        }
        if (setCustomOrder) {
            this.ATOMIC_INTEGER.getAndAdd(maxOrder);
            ArrayList tempList = new ArrayList(apiDocList);
            tempList.forEach(p -> {
                if (p.getOrder() == 0) {
                    p.setOrder(this.ATOMIC_INTEGER.getAndAdd(1));
                }
            });
            apiSchema.setApiDatas(tempList.stream().sorted(Comparator.comparing(JavadocApiDoc::getOrder)).collect(Collectors.toList()));
        } else {
            apiDocList.stream().peek(p -> p.setOrder(this.ATOMIC_INTEGER.getAndAdd(1))).collect(Collectors.toList());
            apiSchema.setApiDatas(apiDocList);
        }
        return apiSchema;
    }

    @Override
    public List<WebSocketDoc> renderWebSocketApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        return null;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return false;
    }

    @Override
    public boolean isEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"javadoc".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        return null;
    }

    private void handleJavaApiDoc(JavaClass cls, List<JavadocApiDoc> apiDocList, List<JavadocJavaMethod> apiMethodDocs, int order, ProjectDocConfigBuilder builder) {
        String className = cls.getCanonicalName();
        String comment = cls.getComment();
        String shortName = cls.getName();
        List javaTypes = cls.getImplements();
        if (!javaTypes.isEmpty() && !cls.isInterface()) {
            JavaType javaType = (JavaType)javaTypes.get(0);
            shortName = className = javaType.getCanonicalName();
            JavaClass javaClass = builder.getClassByName(className);
            if (StringUtil.isEmpty((String)comment) && Objects.nonNull(javaClass)) {
                comment = javaClass.getComment();
            }
        }
        JavadocApiDoc apiDoc = new JavadocApiDoc();
        apiDoc.setOrder(order);
        apiDoc.setName(className);
        apiDoc.setShortName(shortName);
        apiDoc.setAlias(className);
        if (builder.getApiConfig().isMd5EncryptedHtmlName()) {
            String name = DocUtil.generateId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
        apiDoc.setDesc(DocUtil.getEscapeAndCleanComment(comment));
        apiDoc.setList(apiMethodDocs);
        List docletTags = cls.getTags();
        ArrayList<String> authorList = new ArrayList<String>();
        for (DocletTag docletTag : docletTags) {
            String name = docletTag.getName();
            if ("version".equals(name)) {
                apiDoc.setVersion(docletTag.getValue());
            }
            if (!"author".equals(name)) continue;
            authorList.add(docletTag.getValue());
        }
        apiDoc.setAuthor(String.join((CharSequence)", ", authorList));
        apiDocList.add(apiDoc);
    }
}

