/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.JavadocJavaMethod;
import com.ly.doc.model.RpcJavaMethod;
import com.ly.doc.model.WebSocketDoc;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.rpc.RpcApiDoc;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.template.IRpcDocTemplate;
import com.ly.doc.template.IWebSocketDocBuildTemplate;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.ValidateUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class RpcDocBuildTemplate
implements IDocBuildTemplate<RpcApiDoc>,
IWebSocketDocBuildTemplate<WebSocketDoc>,
IRpcDocTemplate {
    private final AtomicInteger ATOMIC_INTEGER = new AtomicInteger(1);

    @Override
    public boolean supportsFramework(String framework) {
        return FrameworkEnum.DUBBO.getFramework().equalsIgnoreCase(framework);
    }

    @Override
    public boolean addMethodModifiers() {
        return false;
    }

    @Override
    public ApiSchema<RpcApiDoc> renderApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        ArrayList<RpcApiDoc> apiDocList = new ArrayList<RpcApiDoc>();
        boolean setCustomOrder = false;
        int maxOrder = 0;
        for (JavaClass cls : candidateClasses) {
            if (this.skipClass(apiConfig, cls, null)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            int order = 0;
            if (ValidateUtil.isNonNegativeInteger((String)strOrder)) {
                order = Integer.parseInt(strOrder);
                setCustomOrder = true;
                maxOrder = Math.max(maxOrder, order);
            }
            List<? extends JavadocJavaMethod> apiMethodDocs = this.buildServiceMethod(cls, apiConfig, projectBuilder);
            this.handleJavaApiDoc(cls, apiDocList, apiMethodDocs, order, projectBuilder);
        }
        ApiSchema<RpcApiDoc> apiSchema = new ApiSchema<RpcApiDoc>();
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
            apiSchema.setApiDatas(apiDocList);
            return apiSchema;
        }
        if (setCustomOrder) {
            this.ATOMIC_INTEGER.getAndAdd(maxOrder);
            ArrayList tempList = new ArrayList(apiDocList);
            tempList.forEach(p -> {
                if (p.getOrder() == 0) {
                    p.setOrder(this.ATOMIC_INTEGER.getAndAdd(1));
                }
            });
            apiSchema.setApiDatas(tempList.stream().sorted(Comparator.comparing(RpcApiDoc::getOrder)).collect(Collectors.toList()));
        } else {
            apiDocList.stream().peek(p -> p.setOrder(this.ATOMIC_INTEGER.getAndAdd(1))).collect(Collectors.toList());
            apiSchema.setApiDatas(apiDocList);
        }
        return apiSchema;
    }

    @Override
    public List<WebSocketDoc> renderWebSocketApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        return null;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return false;
    }

    @Override
    public boolean isEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        if ("org.apache.dubbo.rpc.protocol.rest.integration.swagger.DubboSwaggerApiListingResource".equals(cls.getCanonicalName())) {
            return false;
        }
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getCanonicalName();
            if (!"org.apache.dubbo.config.annotation.Service".equals(name) && !"org.apache.dubbo.config.annotation.DubboService".equals(name) && !"com.alibaba.dubbo.config.annotation.Service".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"dubbo".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        return null;
    }

    private void handleJavaApiDoc(JavaClass cls, List<RpcApiDoc> apiDocList, List<RpcJavaMethod> apiMethodDocs, int order, ProjectDocConfigBuilder builder) {
        String className = cls.getCanonicalName();
        String shortName = cls.getName();
        String comment = cls.getComment();
        List javaTypes = cls.getImplements();
        if (!javaTypes.isEmpty() && !cls.isInterface()) {
            JavaType javaType = (JavaType)javaTypes.get(0);
            shortName = className = javaType.getCanonicalName();
            JavaClass javaClass = builder.getClassByName(className);
            if (StringUtil.isEmpty((String)comment) && Objects.nonNull(javaClass)) {
                comment = javaClass.getComment();
            }
        }
        RpcApiDoc apiDoc = new RpcApiDoc();
        apiDoc.setOrder(order);
        apiDoc.setName(className);
        apiDoc.setShortName(shortName);
        apiDoc.setAlias(className);
        apiDoc.setUri(builder.getServerUrl() + "/" + className);
        apiDoc.setProtocol("dubbo");
        if (builder.getApiConfig().isMd5EncryptedHtmlName()) {
            String name = DocUtil.generateId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
        apiDoc.setDesc(DocUtil.getEscapeAndCleanComment(comment));
        apiDoc.setList(apiMethodDocs);
        List annotations = cls.getAnnotations();
        for (JavaAnnotation annotation : annotations) {
            AnnotationValue interfaceNameValue;
            AnnotationValue protocolValue;
            String name = annotation.getType().getCanonicalName();
            if (!"org.apache.dubbo.config.annotation.DubboService".equals(name)) continue;
            AnnotationValue versionValue = annotation.getProperty("version");
            if (Objects.nonNull(versionValue)) {
                apiDoc.setVersion(StringUtil.removeDoubleQuotes((String)versionValue.getParameterValue().toString()));
            }
            if (Objects.nonNull(protocolValue = annotation.getProperty("protocol"))) {
                apiDoc.setProtocol(StringUtil.removeDoubleQuotes((String)protocolValue.getParameterValue().toString()));
            }
            if (!Objects.nonNull(interfaceNameValue = annotation.getProperty("interfaceName"))) continue;
            apiDoc.setName(StringUtil.removeDoubleQuotes((String)interfaceNameValue.getParameterValue().toString()));
        }
        List docletTags = cls.getTags();
        ArrayList<String> authorList = new ArrayList<String>();
        for (DocletTag docletTag : docletTags) {
            String name = docletTag.getName();
            if ("version".equals(name)) {
                apiDoc.setVersion(docletTag.getValue());
            }
            if ("author".equals(name)) {
                authorList.add(docletTag.getValue());
            }
            if ("protocol".equals(name)) {
                apiDoc.setProtocol(docletTag.getValue());
            }
            if (!"service".equals(name)) continue;
            apiDoc.setName(docletTag.getValue());
        }
        apiDoc.setAuthor(String.join((CharSequence)", ", authorList));
        apiDocList.add(apiDoc);
    }
}

