/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.constants.Methods;
import com.ly.doc.constants.SpringMvcRequestAnnotationsEnum;
import com.ly.doc.handler.SpringMVCRequestHeaderHandler;
import com.ly.doc.handler.SpringMVCRequestMappingHandler;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiExceptionStatus;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.ExceptionAdviceMethod;
import com.ly.doc.model.WebSocketDoc;
import com.ly.doc.model.annotation.EntryAnnotation;
import com.ly.doc.model.annotation.ExceptionAdviceAnnotation;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.annotation.HeaderAnnotation;
import com.ly.doc.model.annotation.MappingAnnotation;
import com.ly.doc.model.annotation.PathVariableAnnotation;
import com.ly.doc.model.annotation.RequestBodyAnnotation;
import com.ly.doc.model.annotation.RequestParamAnnotation;
import com.ly.doc.model.annotation.RequestPartAnnotation;
import com.ly.doc.model.annotation.ServerEndpointAnnotation;
import com.ly.doc.model.request.RequestMapping;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.template.IRestDocTemplate;
import com.ly.doc.template.IWebSocketDocBuildTemplate;
import com.ly.doc.template.IWebSocketTemplate;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.power.common.util.DateTimeUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringBootDocBuildTemplate
implements IDocBuildTemplate<ApiDoc>,
IWebSocketDocBuildTemplate<WebSocketDoc>,
IRestDocTemplate,
IWebSocketTemplate {
    @Override
    public boolean supportsFramework(String framework) {
        return FrameworkEnum.SPRING.getFramework().equalsIgnoreCase(framework);
    }

    @Override
    public ApiSchema<ApiDoc> renderApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        List<ApiReqParam> configApiReqParams = Stream.of(apiConfig.getRequestHeaders(), apiConfig.getRequestParams()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        FrameworkAnnotations frameworkAnnotations = this.registeredAnnotations();
        return this.processApiData(projectBuilder, frameworkAnnotations, configApiReqParams, new SpringMVCRequestMappingHandler(), new SpringMVCRequestHeaderHandler(), candidateClasses);
    }

    @Override
    public List<WebSocketDoc> renderWebSocketApi(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> candidateClasses) {
        FrameworkAnnotations frameworkAnnotations = this.registeredAnnotations();
        return this.processWebSocketData(projectBuilder, frameworkAnnotations, new SpringMVCRequestMappingHandler(), candidateClasses);
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return JavaClassValidateUtil.isMvcIgnoreParams(typeName, ignoreParams);
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        FrameworkAnnotations annotations = FrameworkAnnotations.builder();
        HeaderAnnotation headerAnnotation = HeaderAnnotation.builder().setAnnotationName("RequestHeader").setValueProp("value").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setHeaderAnnotation(headerAnnotation);
        HashMap<String, EntryAnnotation> entryAnnotations = new HashMap<String, EntryAnnotation>(16);
        EntryAnnotation controllerAnnotation = EntryAnnotation.builder().setAnnotationName("Controller").setAnnotationFullyName("Controller");
        entryAnnotations.put(controllerAnnotation.getAnnotationName(), controllerAnnotation);
        EntryAnnotation restController = EntryAnnotation.builder().setAnnotationName("RestController");
        entryAnnotations.put(restController.getAnnotationName(), restController);
        annotations.setEntryAnnotations(entryAnnotations);
        RequestBodyAnnotation bodyAnnotation = RequestBodyAnnotation.builder().setAnnotationName("RequestBody").setAnnotationFullyName("org.springframework.web.bind.annotation.RequestBody");
        annotations.setRequestBodyAnnotation(bodyAnnotation);
        RequestParamAnnotation requestAnnotation = RequestParamAnnotation.builder().setAnnotationName("RequestParam").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setRequestParamAnnotation(requestAnnotation);
        RequestPartAnnotation requestPartAnnotation = RequestPartAnnotation.builder().setAnnotationName("RequestPart").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setRequestPartAnnotation(requestPartAnnotation);
        PathVariableAnnotation pathVariableAnnotation = PathVariableAnnotation.builder().setAnnotationName("PathVariable").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setPathVariableAnnotation(pathVariableAnnotation);
        ServerEndpointAnnotation serverEndpointAnnotation = ServerEndpointAnnotation.builder().setAnnotationName("ServerEndpoint");
        annotations.setServerEndpointAnnotation(serverEndpointAnnotation);
        HashMap<String, MappingAnnotation> mappingAnnotations = new HashMap<String, MappingAnnotation>(16);
        MappingAnnotation requestMappingAnnotation = MappingAnnotation.builder().setAnnotationName("RequestMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setScope("class", "method").setPathProps("value", "path");
        mappingAnnotations.put(requestMappingAnnotation.getAnnotationName(), requestMappingAnnotation);
        MappingAnnotation postMappingAnnotation = MappingAnnotation.builder().setAnnotationName("PostMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.POST.getValue()).setPathProps("value", "path");
        mappingAnnotations.put(postMappingAnnotation.getAnnotationName(), postMappingAnnotation);
        MappingAnnotation getMappingAnnotation = MappingAnnotation.builder().setAnnotationName("GetMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.GET.getValue()).setPathProps("value", "path");
        mappingAnnotations.put(getMappingAnnotation.getAnnotationName(), getMappingAnnotation);
        MappingAnnotation putMappingAnnotation = MappingAnnotation.builder().setAnnotationName("PutMapping").setConsumesProp("consumes").setProducesProp("produces").setParamsProp("params").setMethodProp("method").setMethodType(Methods.PUT.getValue()).setPathProps("value", "path");
        mappingAnnotations.put(putMappingAnnotation.getAnnotationName(), putMappingAnnotation);
        MappingAnnotation patchMappingAnnotation = MappingAnnotation.builder().setAnnotationName("PatchMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.PATCH.getValue()).setPathProps("value", "path");
        mappingAnnotations.put(patchMappingAnnotation.getAnnotationName(), patchMappingAnnotation);
        MappingAnnotation deleteMappingAnnotation = MappingAnnotation.builder().setAnnotationName("DeleteMapping").setConsumesProp("consumes").setProducesProp("produces").setMethodProp("method").setParamsProp("params").setMethodType(Methods.DELETE.getValue()).setPathProps("value", "path");
        mappingAnnotations.put(deleteMappingAnnotation.getAnnotationName(), deleteMappingAnnotation);
        MappingAnnotation feignClientAnnotation = MappingAnnotation.builder().setAnnotationName("FeignClient").setAnnotationFullyName("org.springframework.cloud.netflix.feign.FeignClient");
        mappingAnnotations.put(feignClientAnnotation.getAnnotationName(), feignClientAnnotation);
        annotations.setMappingAnnotations(mappingAnnotations);
        HashMap<String, ExceptionAdviceAnnotation> exceptionAdviceAnnotations = new HashMap<String, ExceptionAdviceAnnotation>(16);
        ExceptionAdviceAnnotation controllerAdviceAnnotation = ExceptionAdviceAnnotation.builder().setAnnotationName("ControllerAdvice");
        exceptionAdviceAnnotations.put(controllerAdviceAnnotation.getAnnotationName(), controllerAdviceAnnotation);
        ExceptionAdviceAnnotation restControllerAdviceAnnotation = ExceptionAdviceAnnotation.builder().setAnnotationName("RestControllerAdvice");
        exceptionAdviceAnnotations.put(restControllerAdviceAnnotation.getAnnotationName(), restControllerAdviceAnnotation);
        annotations.setExceptionAdviceAnnotations(exceptionAdviceAnnotations);
        return annotations;
    }

    @Override
    public boolean isEntryPoint(JavaClass javaClass, FrameworkAnnotations frameworkAnnotations) {
        boolean isDefaultEntryPoint = this.defaultEntryPoint(javaClass, frameworkAnnotations);
        if (isDefaultEntryPoint) {
            return true;
        }
        if (javaClass.isAnnotation() || javaClass.isEnum()) {
            return false;
        }
        List docletTags = javaClass.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"restApi".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> listMvcRequestAnnotations() {
        return SpringMvcRequestAnnotationsEnum.listSpringMvcRequestAnnotations();
    }

    @Override
    public void requestMappingPostProcess(JavaClass javaClass, JavaMethod method, RequestMapping requestMapping) {
    }

    @Override
    public boolean ignoreMvcParamWithAnnotation(String annotation) {
        return JavaClassValidateUtil.ignoreSpringMvcParamWithAnnotation(annotation);
    }

    @Override
    public boolean isExceptionAdviceEntryPoint(JavaClass javaClass, FrameworkAnnotations frameworkAnnotations) {
        return this.defaultExceptionAdviceEntryPoint(javaClass, frameworkAnnotations);
    }

    @Override
    public ExceptionAdviceMethod processExceptionAdviceMethod(JavaMethod method) {
        List annotations = method.getAnnotations();
        boolean isExceptionHandlerMethod = false;
        String status = null;
        for (JavaAnnotation annotation : annotations) {
            Object consumes;
            String annotationName = annotation.getType().getValue();
            if ("ExceptionHandler".equals(annotationName)) {
                isExceptionHandlerMethod = true;
            }
            if (!"ResponseStatus".equals(annotationName) || !Objects.nonNull(consumes = annotation.getNamedParameter("value"))) continue;
            status = consumes.toString();
        }
        return ExceptionAdviceMethod.builder().setExceptionHandlerMethod(isExceptionHandlerMethod).setStatus(status);
    }

    @Override
    public List<ApiExceptionStatus> defaultHttpErrorStatuses() {
        ZonedDateTime now = ZonedDateTime.now();
        String strDateTime = DateTimeUtil.zonedDateTimeToStr((ZonedDateTime)now, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        ApiParam errorParam = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("error").setType("string").setValue("error").setDesc("error message");
        ApiParam pathParam = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("path").setType("string").setValue("").setDesc("request path");
        ApiParam timestampParam = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("timestamp").setType("string").setValue("").setDesc("timestamp");
        ApiParam status500Param = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("status").setType("int").setValue("500").setDesc("Internal Server Error").setRequired(true);
        ApiParam status400Param = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("status").setType("int").setValue("400").setDesc("Bad Request").setRequired(true);
        ApiParam status404Param = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("status").setType("int").setValue("404").setDesc("Not Found").setRequired(true);
        ApiParam status401Param = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("status").setType("int").setValue("401").setDesc("Unauthorized").setRequired(true);
        ApiParam status403Param = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("status").setType("int").setValue("403").setDesc("Forbidden").setRequired(true);
        ApiParam status405Param = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("status").setType("int").setValue("405").setDesc("Method Not Allowed").setRequired(true);
        ApiParam status415Param = ApiParam.of().setClassName("HttpErrorStatusResponse").setField("status").setType("int").setValue("415").setDesc("Unsupported Media Type").setRequired(true);
        ArrayList<ApiExceptionStatus> exceptionStatusList = new ArrayList<ApiExceptionStatus>();
        exceptionStatusList.add(ApiExceptionStatus.of().setStatus("500").setDesc("Internal Server Error").setResponseUsage("{\n  \"timestamp\": \"" + strDateTime + "\",\n  \"status\": 500,\n  \"error\": \"Internal Server Error\",\n  \"path\": \"/api/v1/xx\"\n}").setExceptionResponseParams(Arrays.asList(errorParam, pathParam, timestampParam, status500Param)));
        exceptionStatusList.add(ApiExceptionStatus.of().setStatus("400").setDesc("Bad Request").setResponseUsage("{\n  \"timestamp\": \"" + strDateTime + "\",\n  \"status\": 400,\n  \"error\": \"Bad Request\",\n  \"path\": \"/api/v1/xx\"\n}").setExceptionResponseParams(Arrays.asList(errorParam, pathParam, timestampParam, status400Param)));
        exceptionStatusList.add(ApiExceptionStatus.of().setStatus("404").setDesc("Not Found").setResponseUsage("{\n  \"timestamp\": \"" + strDateTime + "\",\n  \"status\": 404,\n  \"error\": \"Not Found\",\n  \"path\": \"/api/v1/xx\"\n}").setExceptionResponseParams(Arrays.asList(errorParam, pathParam, timestampParam, status404Param)));
        exceptionStatusList.add(ApiExceptionStatus.of().setStatus("401").setDesc("Unauthorized").setResponseUsage("{\n  \"timestamp\": \"" + strDateTime + "\",\n  \"status\": 401,\n  \"error\": \"Unauthorized\",\n  \"path\": \"/api/v1/xx\"\n} ").setExceptionResponseParams(Arrays.asList(errorParam, pathParam, timestampParam, status401Param)));
        exceptionStatusList.add(ApiExceptionStatus.of().setStatus("403").setDesc("Forbidden").setResponseUsage("{\n  \"timestamp\": \"" + strDateTime + "\",\n  \"status\": 403,\n  \"error\": \"Forbidden\",\n  \"path\": \"/api/v1/xx\"\n} ").setExceptionResponseParams(Arrays.asList(errorParam, pathParam, timestampParam, status403Param)));
        exceptionStatusList.add(ApiExceptionStatus.of().setStatus("405").setDesc("Method Not Allowed").setResponseUsage("{\n  \"timestamp\": \"" + strDateTime + "\",\n  \"status\": 405,\n  \"error\": \"Method Not Allowed\",\n  \"path\": \"/api/v1/xx\"\n} ").setExceptionResponseParams(Arrays.asList(errorParam, pathParam, timestampParam, status405Param)));
        exceptionStatusList.add(ApiExceptionStatus.of().setStatus("415").setDesc("Unsupported Media Type").setResponseUsage("{\n  \"timestamp\": \"" + strDateTime + "\",\n  \"status\": 415,\n  \"error\": \"Unsupported Media Type\",\n  \"path\": \"/api/v1/xx\"\n} ").setExceptionResponseParams(Arrays.asList(errorParam, pathParam, timestampParam, status415Param)));
        return exceptionStatusList;
    }
}

