/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.utils;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.DefaultClassConstants;
import com.ly.doc.constants.DocValidatorAnnotationEnum;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDataDictionary;
import com.ly.doc.model.DocJavaField;
import com.ly.doc.model.torna.EnumInfo;
import com.ly.doc.model.torna.Item;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.EnumUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameterizedType;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.AnnotationValueList;
import com.thoughtworks.qdox.model.expression.TypeRef;
import com.thoughtworks.qdox.model.impl.DefaultJavaField;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JavaClassUtil {
    public static List<DocJavaField> getFields(JavaClass cls1, int counter, Map<String, DocJavaField> addedFields, ClassLoader classLoader) {
        HashMap<String, JavaType> actualJavaTypes = new HashMap<String, JavaType>(10);
        List<DocJavaField> fields = JavaClassUtil.getFields(cls1, counter, addedFields, actualJavaTypes, classLoader);
        for (DocJavaField field : fields) {
            JavaType actualJavaType;
            String genericCanonicalName = field.getTypeGenericCanonicalName();
            if (Objects.isNull(genericCanonicalName) || Objects.isNull(actualJavaType = (JavaType)actualJavaTypes.get(genericCanonicalName))) continue;
            field.setTypeGenericCanonicalName(genericCanonicalName.replace(genericCanonicalName, actualJavaType.getGenericCanonicalName()));
            field.setTypeFullyQualifiedName(field.getTypeFullyQualifiedName().replace(genericCanonicalName, actualJavaType.getFullyQualifiedName()));
            field.setActualJavaType(actualJavaType.getFullyQualifiedName());
        }
        return fields;
    }

    private static List<DocJavaField> getFields(JavaClass cls1, int counter, Map<String, DocJavaField> addedFields, Map<String, JavaType> actualJavaTypes, ClassLoader classLoader) {
        JavaClass parentClass;
        DocJavaField docJavaField;
        ArrayList<DocJavaField> fieldList = new ArrayList<DocJavaField>();
        if (Objects.isNull(cls1)) {
            return fieldList;
        }
        if (cls1.isEnum()) {
            return fieldList;
        }
        String className = cls1.getFullyQualifiedName();
        if (JavaClassValidateUtil.isJdkClass(className)) {
            return fieldList;
        }
        if (cls1.isInterface()) {
            List methods = cls1.getMethods();
            for (JavaMethod javaMethod : methods) {
                String methodName = javaMethod.getName();
                int paramSize = javaMethod.getParameters().size();
                boolean enable = false;
                if (methodName.startsWith("get") && !"get".equals(methodName) && paramSize == 0) {
                    methodName = StringUtil.firstToLowerCase((String)methodName.substring(3));
                    enable = true;
                } else if (methodName.startsWith("is") && !"is".equals(methodName) && paramSize == 0) {
                    methodName = StringUtil.firstToLowerCase((String)methodName.substring(2));
                    enable = true;
                }
                if (!enable || addedFields.containsKey(methodName)) continue;
                String comment = javaMethod.getComment();
                if (StringUtil.isEmpty((String)comment)) {
                    comment = "No comments found.";
                }
                DefaultJavaField javaField = new DefaultJavaField(javaMethod.getReturns(), methodName);
                docJavaField = DocJavaField.builder().setDeclaringClassName(className).setFieldName(methodName).setJavaField((JavaField)javaField).setComment(comment).setDocletTags(javaMethod.getTags()).setAnnotations(javaMethod.getAnnotations()).setTypeFullyQualifiedName(javaField.getType().getFullyQualifiedName()).setTypeGenericCanonicalName(JavaClassUtil.getReturnGenericType(javaMethod, classLoader)).setTypeGenericFullyQualifiedName(javaField.getType().getGenericFullyQualifiedName()).setTypeSimpleName(javaField.getType().getSimpleName());
                addedFields.put(methodName, docJavaField);
            }
        }
        if (Objects.nonNull(parentClass = cls1.getSuperJavaClass())) {
            JavaClassUtil.getFields(parentClass, counter, addedFields, actualJavaTypes, classLoader);
        }
        List implClasses = cls1.getImplements();
        for (Object type : implClasses) {
            JavaClass javaClass = (JavaClass)type;
            JavaClassUtil.getFields(javaClass, counter, addedFields, actualJavaTypes, classLoader);
        }
        actualJavaTypes.putAll(JavaClassUtil.getActualTypesMap(cls1));
        List javaMethods = cls1.getMethods();
        for (JavaMethod method : javaMethods) {
            String methodName = method.getName();
            if (method.getAnnotations().isEmpty()) continue;
            int paramSize = method.getParameters().size();
            if (methodName.startsWith("get") && !"get".equals(methodName) && paramSize == 0) {
                methodName = StringUtil.firstToLowerCase((String)methodName.substring(3));
            } else if (methodName.startsWith("is") && !"is".equals(methodName) && paramSize == 0) {
                methodName = StringUtil.firstToLowerCase((String)methodName.substring(2));
            }
            if (!addedFields.containsKey(methodName)) continue;
            String comment = method.getComment();
            if (Objects.isNull(comment)) {
                comment = addedFields.get(methodName).getComment();
            }
            if (StringUtil.isEmpty((String)comment)) {
                comment = "No comments found.";
            }
            docJavaField = addedFields.get(methodName);
            docJavaField.setAnnotations(method.getAnnotations());
            docJavaField.setComment(comment);
            docJavaField.setFieldName(methodName);
            docJavaField.setDeclaringClassName(className);
            addedFields.put(methodName, docJavaField);
        }
        if (!cls1.isInterface()) {
            Map<Object, Object> recordComments = new HashMap(0);
            if (cls1.isRecord()) {
                recordComments = DocUtil.getRecordCommentsByTag(cls1, "param");
            }
            for (JavaField javaField : cls1.getFields()) {
                String genericFieldTypeName;
                long count;
                String fieldName = javaField.getName();
                String subTypeName = javaField.getType().getFullyQualifiedName();
                if (javaField.isStatic() || "this$0".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName)) continue;
                if (fieldName.startsWith("is") && "boolean".equals(subTypeName)) {
                    fieldName = StringUtil.firstToLowerCase((String)fieldName.substring(2));
                }
                if ((count = javaField.getAnnotations().stream().filter(annotation -> "JsonIgnore".equals(annotation.getType().getSimpleName())).count()) > 0L) {
                    addedFields.remove(fieldName);
                    continue;
                }
                DocJavaField docJavaField2 = DocJavaField.builder();
                boolean typeChecked = false;
                JavaClass fieldType = javaField.getType();
                String gicName = fieldType.getGenericCanonicalName();
                String actualType = null;
                if (JavaClassValidateUtil.isCollection(subTypeName) && !JavaClassValidateUtil.isCollection(gicName)) {
                    String[] gNameArr = DocClassUtil.getSimpleGicName(gicName);
                    actualType = JavaClassUtil.getClassSimpleName(gNameArr[0]);
                    docJavaField2.setArray(true);
                    typeChecked = true;
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName) && !typeChecked) {
                    docJavaField2.setPrimitive(true);
                    typeChecked = true;
                }
                if (JavaClassValidateUtil.isFile(subTypeName) && !typeChecked) {
                    docJavaField2.setFile(true);
                    typeChecked = true;
                }
                if (javaField.getType().isEnum() && !typeChecked) {
                    docJavaField2.setEnum(true);
                }
                String comment = javaField.getComment();
                if (cls1.isRecord()) {
                    comment = (String)recordComments.get(fieldName);
                }
                if (Objects.isNull(comment)) {
                    comment = "No comments found.";
                }
                if (!(docJavaField2.isFile() && docJavaField2.isEnum() && docJavaField2.isPrimitive() && !"java.lang.Object".equals(gicName) || !StringUtil.isNotEmpty((String)(genericFieldTypeName = JavaClassUtil.getFieldGenericType(javaField, classLoader))))) {
                    gicName = genericFieldTypeName;
                }
                docJavaField2.setComment(comment).setJavaField(javaField).setTypeFullyQualifiedName(subTypeName).setTypeGenericCanonicalName(gicName).setTypeGenericFullyQualifiedName(fieldType.getGenericFullyQualifiedName()).setActualJavaType(actualType).setAnnotations(javaField.getAnnotations()).setFieldName(fieldName).setDeclaringClassName(className).setTypeSimpleName(javaField.getType().getSimpleName());
                if (addedFields.containsKey(fieldName)) {
                    addedFields.remove(fieldName);
                    addedFields.put(fieldName, docJavaField2);
                    continue;
                }
                addedFields.put(fieldName, docJavaField2);
            }
        }
        List parentFieldList = addedFields.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        fieldList.addAll(parentFieldList);
        return fieldList;
    }

    public static String getSameSignatureMethodCommonFromInterface(JavaClass cls, JavaMethod method) {
        List methodsBySignature = cls.getMethodsBySignature(method.getName(), method.getParameterTypes(), true, method.isVarArgs());
        for (JavaMethod sameSignatureMethod : methodsBySignature) {
            if (sameSignatureMethod == method || sameSignatureMethod.getDeclaringClass() == null || !sameSignatureMethod.getDeclaringClass().isInterface() || sameSignatureMethod.getComment() == null) continue;
            return sameSignatureMethod.getComment();
        }
        return null;
    }

    public static Object getEnumValue(JavaClass javaClass, boolean formDataEnum) {
        List javaFields = javaClass.getEnumConstants();
        if (Objects.isNull(javaFields)) {
            throw new RuntimeException(javaClass.getName() + " enum not existed");
        }
        List methodList = javaClass.getMethods();
        String methodName = null;
        block0: for (JavaMethod method : methodList) {
            List annotations = method.getAnnotations();
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if (!"JsonValue".equals(annotationName) && !"JsonCreator".equals(annotationName)) continue;
                methodName = method.getName();
                continue block0;
            }
        }
        String value = null;
        int index = 0;
        for (JavaField javaField : javaFields) {
            String simpleName = javaField.getType().getSimpleName();
            StringBuilder valueBuilder = new StringBuilder();
            valueBuilder.append("\"").append(javaField.getName()).append("\"");
            if (formDataEnum) {
                value = valueBuilder.toString();
                return value;
            }
            if (!JavaClassValidateUtil.isPrimitive(simpleName) && index < 1) {
                value = CollectionUtil.isNotEmpty((Collection)javaField.getEnumConstantArguments()) && Objects.nonNull(methodName) ? javaField.getEnumConstantArguments().get(0) : valueBuilder.toString();
            }
            ++index;
        }
        return value;
    }

    public static String getEnumParams(JavaClass javaClass) {
        List javaFields = javaClass.getEnumConstants();
        StringBuilder stringBuilder = new StringBuilder();
        for (JavaField javaField : javaFields) {
            String exception = javaField.getInitializationExpression();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(javaField.getName());
            if (!StringUtil.isNotEmpty((String)exception)) continue;
            stringBuilder.append("(").append(exception).append(")").append("<br/>");
        }
        return stringBuilder.toString();
    }

    public static List<String> getEnumValues(JavaClass javaClass) {
        List javaFields = javaClass.getEnumConstants();
        ArrayList<String> enums = new ArrayList<String>();
        for (JavaField javaField : javaFields) {
            enums.add(javaField.getName());
        }
        return enums;
    }

    public static JavaClass getSeeEnum(JavaField javaField, ProjectDocConfigBuilder builder) {
        if (Objects.isNull(javaField)) {
            return null;
        }
        JavaClass javaClass = javaField.getType();
        if (javaClass.isEnum()) {
            return javaClass;
        }
        DocletTag see = javaField.getTagByName("see");
        if (Objects.isNull(see)) {
            return null;
        }
        String value = see.getValue();
        if (!StringUtils.contains((CharSequence)value, (CharSequence)".")) {
            List imports = javaField.getDeclaringClass().getSource().getImports();
            String finalValue = value;
            value = imports.stream().filter(i -> StringUtils.endsWith((CharSequence)i, (CharSequence)finalValue)).findFirst().orElse("");
        }
        if (!JavaClassValidateUtil.isClassName(value)) {
            return null;
        }
        JavaClass enumClass = builder.getJavaProjectBuilder().getClassByName(value);
        if (enumClass.isEnum()) {
            return enumClass;
        }
        return null;
    }

    public static EnumInfo getEnumInfo(JavaClass javaClass, ProjectDocConfigBuilder builder) {
        if (Objects.isNull(javaClass) || !javaClass.isEnum()) {
            return null;
        }
        if (Objects.nonNull(javaClass.getTagByName("ignore"))) {
            return null;
        }
        ApiConfig apiConfig = builder.getApiConfig();
        ClassLoader classLoader = apiConfig.getClassLoader();
        ApiDataDictionary dataDictionary = apiConfig.getDataDictionary(javaClass.getFullyQualifiedName());
        EnumInfo enumInfo = new EnumInfo();
        String comment = javaClass.getComment();
        DocletTag apiNoteTag = javaClass.getTagByName("apiNote");
        enumInfo.setName(comment);
        enumInfo.setDescription(DocUtil.getEscapeAndCleanComment(Optional.ofNullable(apiNoteTag).map(DocletTag::getValue).orElse("")));
        List enumConstants = javaClass.getEnumConstants();
        if (Objects.nonNull(dataDictionary)) {
            Class<?> enumClass = dataDictionary.getEnumClass();
            if (enumClass.isInterface()) {
                try {
                    enumClass = classLoader.loadClass(javaClass.getFullyQualifiedName());
                }
                catch (ClassNotFoundException e) {
                    return enumInfo;
                }
            }
            List enumInformation = EnumUtil.getEnumInformation(enumClass, (String)dataDictionary.getCodeField(), (String)dataDictionary.getDescField());
            List<Item> itemList = enumInformation.stream().map(i -> new Item(i.getName(), i.getType(), i.getValue(), i.getDesc())).collect(Collectors.toList());
            enumInfo.setItems(itemList);
            if (StringUtils.isNotEmpty((CharSequence)dataDictionary.getTitle())) {
                enumInfo.setName(dataDictionary.getTitle());
            }
            return enumInfo;
        }
        List<Item> collect = enumConstants.stream().map(cons -> {
            Item item = new Item();
            String name = cons.getName();
            String enumComment = cons.getComment();
            item.setName(name);
            item.setType("string");
            item.setValue(name);
            item.setDescription(enumComment);
            return item;
        }).collect(Collectors.toList());
        enumInfo.setItems(collect);
        return enumInfo;
    }

    public static String getAnnotationSimpleName(String annotationName) {
        return JavaClassUtil.getClassSimpleName(annotationName);
    }

    public static String getClassSimpleName(String className) {
        int index;
        if (className.contains(".")) {
            if (className.contains("<")) {
                className = className.substring(0, className.indexOf("<"));
            }
            index = className.lastIndexOf(".");
            className = className.substring(index + 1);
        }
        if (className.contains("[")) {
            index = className.indexOf("[");
            className = className.substring(0, index);
        }
        return className;
    }

    public static JavaType getActualType(JavaClass javaClass) {
        return JavaClassUtil.getActualTypes((JavaType)javaClass).get(0);
    }

    public static List<JavaType> getActualTypes(JavaType javaType) {
        if (Objects.isNull(javaType)) {
            return new ArrayList<JavaType>(0);
        }
        String typeName = javaType.getGenericFullyQualifiedName();
        if (typeName.contains("<")) {
            return ((JavaParameterizedType)javaType).getActualTypeArguments();
        }
        return new ArrayList<JavaType>(0);
    }

    public static Map<String, JavaType> getActualTypesMap(JavaClass javaClass) {
        HashMap<String, JavaType> genericMap = new HashMap<String, JavaType>(10);
        List variables = javaClass.getTypeParameters();
        if (variables.isEmpty()) {
            return genericMap;
        }
        List<JavaType> javaTypes = JavaClassUtil.getActualTypes((JavaType)javaClass);
        for (int i = 0; i < variables.size(); ++i) {
            if (javaTypes.isEmpty()) continue;
            genericMap.put(((JavaTypeVariable)variables.get(i)).getName(), javaTypes.get(i));
        }
        return genericMap;
    }

    public static Set<String> getParamGroupJavaClass(List<JavaAnnotation> annotations, JavaProjectBuilder builder) {
        if (CollectionUtil.isEmpty(annotations)) {
            return new HashSet<String>(0);
        }
        HashSet<String> javaClassList = new HashSet<String>();
        List<String> validates = DocValidatorAnnotationEnum.listValidatorAnnotations();
        for (JavaAnnotation javaAnnotation : annotations) {
            List<AnnotationValue> annotationValueList = JavaClassUtil.getAnnotationValues(validates, javaAnnotation);
            JavaClassUtil.addGroupClass(annotationValueList, javaClassList, builder);
            String simpleAnnotationName = javaAnnotation.getType().getValue();
            if (!javaClassList.isEmpty() || !"Validated".equals(simpleAnnotationName) && !"Valid".equals(simpleAnnotationName)) continue;
            javaClassList.addAll(DefaultClassConstants.DEFAULT_CLASSES);
        }
        return javaClassList;
    }

    public static Set<String> getParamGroupJavaClass(JavaAnnotation javaAnnotation) {
        if (Objects.isNull(javaAnnotation)) {
            return new HashSet<String>(0);
        }
        HashSet<String> javaClassList = new HashSet<String>();
        List<String> validates = DocValidatorAnnotationEnum.listValidatorAnnotations();
        List<AnnotationValue> annotationValueList = JavaClassUtil.getAnnotationValues(validates, javaAnnotation);
        JavaClassUtil.addGroupClass(annotationValueList, javaClassList);
        String simpleAnnotationName = javaAnnotation.getType().getValue();
        if (javaClassList.isEmpty() && JavaClassValidateUtil.isJSR303Required(simpleAnnotationName)) {
            javaClassList.addAll(DefaultClassConstants.DEFAULT_CLASSES);
        }
        return javaClassList;
    }

    public static String getClassTagsValue(JavaClass cls, String tagName, boolean checkComments) {
        if (StringUtil.isNotEmpty((String)tagName)) {
            StringBuilder result = new StringBuilder();
            List tags = cls.getTags();
            for (DocletTag tag : tags) {
                if (!tagName.equals(tag.getName())) continue;
                String value = tag.getValue();
                if (StringUtil.isEmpty((String)value) && checkComments) {
                    throw new RuntimeException("ERROR: #" + cls.getName() + "() - bad @" + tagName + " Javadoc tag usage from " + cls.getName() + ", must be add comment if you use it.");
                }
                if (!tagName.equals(tag.getName())) continue;
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(value);
            }
            return result.toString();
        }
        return "";
    }

    public static Map<String, String> getFinalFieldValue(Class<?> clazz) throws IllegalAccessException {
        String className = JavaClassUtil.getClassSimpleName(clazz.getName());
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, String> constants = new HashMap<String, String>(16);
        for (Field field : fields) {
            if (Modifier.isPrivate(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            String name = field.getName();
            constants.put(className + "." + name, String.valueOf(field.get(null)));
        }
        return constants;
    }

    private static void addGroupClass(List<AnnotationValue> annotationValueList, Set<String> javaClassList) {
        if (CollectionUtil.isEmpty(annotationValueList)) {
            return;
        }
        for (AnnotationValue annotationValue : annotationValueList) {
            TypeRef typeRef = (TypeRef)annotationValue;
            DefaultJavaParameterizedType annotationValueType = (DefaultJavaParameterizedType)typeRef.getType();
            javaClassList.add(annotationValueType.getGenericFullyQualifiedName());
        }
    }

    private static void addGroupClass(List<AnnotationValue> annotationValueList, Set<String> javaClassList, JavaProjectBuilder builder) {
        if (CollectionUtil.isEmpty(annotationValueList)) {
            return;
        }
        for (AnnotationValue annotationValue : annotationValueList) {
            TypeRef typeRef = (TypeRef)annotationValue;
            DefaultJavaParameterizedType annotationValueType = (DefaultJavaParameterizedType)typeRef.getType();
            String genericCanonicalName = annotationValueType.getGenericFullyQualifiedName();
            JavaClass classByName = builder.getClassByName(genericCanonicalName);
            JavaClassUtil.recursionGetAllValidInterface(classByName, javaClassList, builder);
            javaClassList.add(genericCanonicalName);
        }
    }

    private static void recursionGetAllValidInterface(JavaClass classByName, Set<String> javaClassSet, JavaProjectBuilder builder) {
        List anImplements = classByName.getImplements();
        if (CollectionUtil.isEmpty((Collection)anImplements)) {
            return;
        }
        for (JavaType javaType : anImplements) {
            String genericFullyQualifiedName = javaType.getGenericFullyQualifiedName();
            javaClassSet.add(genericFullyQualifiedName);
            if (DefaultClassConstants.DEFAULT_CLASSES.contains(genericFullyQualifiedName)) continue;
            JavaClass implementJavaClass = builder.getClassByName(genericFullyQualifiedName);
            JavaClassUtil.recursionGetAllValidInterface(implementJavaClass, javaClassSet, builder);
        }
    }

    private static List<AnnotationValue> getAnnotationValues(List<String> validates, JavaAnnotation javaAnnotation) {
        List<Object> annotationValueList = new ArrayList<AnnotationValue>();
        String simpleName = javaAnnotation.getType().getValue();
        if (simpleName.equalsIgnoreCase("Validated")) {
            if (Objects.nonNull(javaAnnotation.getProperty("value"))) {
                AnnotationValue v = javaAnnotation.getProperty("value");
                if (v instanceof AnnotationValueList) {
                    annotationValueList = ((AnnotationValueList)v).getValueList();
                }
                if (v instanceof TypeRef) {
                    annotationValueList.add(v);
                }
            }
        } else if (validates.contains(simpleName) && Objects.nonNull(javaAnnotation.getProperty("groups"))) {
            AnnotationValue v = javaAnnotation.getProperty("groups");
            if (v instanceof AnnotationValueList) {
                annotationValueList = ((AnnotationValueList)v).getValueList();
            }
            if (v instanceof TypeRef) {
                annotationValueList.add(v);
            }
        }
        return annotationValueList;
    }

    public static void genericParamMap(Map<String, String> genericMap, JavaClass cls, String[] globGicName) {
        if (Objects.isNull(cls) || Objects.isNull(cls.getTypeParameters())) {
            return;
        }
        List variables = cls.getTypeParameters();
        if (!variables.isEmpty()) {
            for (int i = 0; i < cls.getTypeParameters().size() && i < globGicName.length; ++i) {
                genericMap.put(((JavaTypeVariable)variables.get(i)).getName(), globGicName[i]);
            }
            return;
        }
        try {
            Class<?> c = Class.forName(cls.getCanonicalName());
            TypeVariable<Class<?>>[] tValue = c.getTypeParameters();
            for (int i = 0; i < tValue.length && i < globGicName.length; ++i) {
                genericMap.put(tValue[i].getName(), globGicName[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static String javaTypeFormat(String returnType) {
        if (returnType.contains("?")) {
            return returnType.replaceAll("[?\\s]", "").replaceAll("extends", "");
        }
        return returnType;
    }

    public static boolean isTargetChildClass(String sourceClass, String targetClass) {
        try {
            if (sourceClass.equals(targetClass)) {
                return true;
            }
            for (Class<?> c = Class.forName(sourceClass); c != null; c = c.getSuperclass()) {
                if (!c.getName().equals(targetClass)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            e.getMessage();
            return false;
        }
        return false;
    }

    public static Map<String, String> getClassJsonIgnoreFields(JavaClass cls) {
        if (Objects.isNull(cls)) {
            return Collections.emptyMap();
        }
        List classAnnotation = cls.getAnnotations();
        HashMap<String, String> ignoreFields = new HashMap<String, String>(16);
        for (JavaAnnotation annotation : classAnnotation) {
            String simpleAnnotationName = annotation.getType().getValue();
            if ("JsonIgnoreProperties".equalsIgnoreCase(simpleAnnotationName)) {
                return JavaClassUtil.getJsonIgnoresProp(annotation, "value");
            }
            if (!"JSONType".equals(simpleAnnotationName)) continue;
            return JavaClassUtil.getJsonIgnoresProp(annotation, "ignores");
        }
        return ignoreFields;
    }

    public static Map<String, String> getJsonIgnoresProp(JavaAnnotation annotation, String propName) {
        HashMap<String, String> ignoreFields = new HashMap<String, String>(16);
        Object ignoresObject = annotation.getNamedParameter(propName);
        if (Objects.isNull(ignoresObject)) {
            return ignoreFields;
        }
        if (ignoresObject instanceof String) {
            String prop = StringUtil.removeQuotes((String)ignoresObject.toString());
            ignoreFields.put(prop, null);
            return ignoreFields;
        }
        LinkedList ignorePropList = (LinkedList)ignoresObject;
        for (String str : ignorePropList) {
            String prop = StringUtil.removeQuotes((String)str);
            ignoreFields.put(prop, null);
        }
        return ignoreFields;
    }

    private static String getFieldGenericType(JavaField javaField, ClassLoader classLoader) {
        if (JavaClassValidateUtil.isPrimitive(javaField.getType().getGenericCanonicalName()) || javaField.isFinal() && javaField.isPrivate()) {
            return null;
        }
        String name = javaField.getName();
        try {
            Class<?> c = Objects.nonNull(classLoader) ? classLoader.loadClass(javaField.getDeclaringClass().getCanonicalName()) : Class.forName(javaField.getDeclaringClass().getCanonicalName());
            Field f = c.getDeclaredField(name);
            f.setAccessible(true);
            Type t = f.getGenericType();
            return StringUtil.trim((String)t.getTypeName());
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchFieldException e) {
            return null;
        }
    }

    private static String getReturnGenericType(JavaMethod javaMethod, ClassLoader classLoader) {
        String methodName = javaMethod.getName();
        String binaryName = javaMethod.getDeclaringClass().getBinaryName();
        try {
            Class<?> c = Objects.nonNull(classLoader) ? classLoader.loadClass(binaryName) : Class.forName(binaryName);
            Method m = c.getDeclaredMethod(methodName, new Class[0]);
            Type t = m.getGenericReturnType();
            return StringUtil.trim((String)t.getTypeName());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    public static String getGenericsNameByActualTypesMap(String originalName, Map<String, JavaType> actualTypesMap) {
        int typeNameLastLeftIndex = originalName.lastIndexOf(60);
        int typeNameFirstRightIndex = originalName.indexOf(62, typeNameLastLeftIndex);
        if (typeNameLastLeftIndex > 0 && typeNameFirstRightIndex > 0) {
            String genericsString = originalName.substring(typeNameLastLeftIndex + 1, typeNameFirstRightIndex);
            String[] generics = genericsString.split(",");
            StringBuilder resultString = new StringBuilder();
            resultString.append(originalName, 0, typeNameLastLeftIndex + 1);
            for (String generic : generics) {
                String trimmedGeneric = generic.trim();
                JavaType mappedType = actualTypesMap.get(trimmedGeneric);
                resultString.append(mappedType != null ? mappedType.getCanonicalName() : trimmedGeneric);
                resultString.append(",");
            }
            resultString.setLength(resultString.length() - 1);
            resultString.append(originalName, typeNameFirstRightIndex, originalName.length());
            return resultString.toString();
        }
        return originalName;
    }
}

