/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.utils;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.ValidateUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.List;
import java.util.Objects;

public class JavaClassValidateUtil {
    private static final String CLASS_PATTERN = "^([A-Za-z]{1}[A-Za-z\\d_]*\\.)+[A-Za-z][A-Za-z\\d_]*$";

    public static boolean isPrimitiveArray(String type0) {
        String type = type0.contains("java.lang") ? type0.substring(type0.lastIndexOf(".") + 1) : type0;
        switch (type = type.toLowerCase()) {
            case "integer[]": 
            case "void": 
            case "int[]": 
            case "long[]": 
            case "double[]": 
            case "float[]": 
            case "short[]": 
            case "bigdecimal[]": 
            case "char[]": 
            case "string[]": 
            case "boolean[]": 
            case "byte[]": {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitive(String type0) {
        if (Objects.isNull(type0)) {
            return true;
        }
        String type = type0.contains("java.lang") ? type0.substring(type0.lastIndexOf(".") + 1) : type0;
        switch (type = type.toLowerCase()) {
            case "integer": 
            case "void": 
            case "int": 
            case "long": 
            case "double": 
            case "float": 
            case "short": 
            case "bigdecimal": 
            case "char": 
            case "string": 
            case "number": 
            case "boolean": 
            case "byte": 
            case "uuid": 
            case "character": 
            case "java.sql.timestamp": 
            case "java.util.date": 
            case "java.util.calendar": 
            case "java.time.zoneoffset": 
            case "java.time.offsettime": 
            case "java.time.instant": 
            case "java.time.localdatetime": 
            case "java.time.localtime": 
            case "java.time.year": 
            case "java.time.yearmonth": 
            case "java.time.monthday": 
            case "java.time.period": 
            case "localdatetime": 
            case "localdate": 
            case "zoneddatetime": 
            case "offsetdatetime": 
            case "period": 
            case "java.time.localdate": 
            case "java.time.zoneddatetime": 
            case "java.time.offsetdatetime": 
            case "java.math.bigdecimal": 
            case "java.math.biginteger": 
            case "java.util.uuid": 
            case "java.io.serializable": 
            case "java.lang.character": 
            case "org.bson.types.objectid": {
                return true;
            }
        }
        return false;
    }

    public static boolean isJdkClass(String type) {
        return type.startsWith("java") || type.startsWith("javax") || type.startsWith("com.sum");
    }

    public static boolean isCollection(String type) {
        switch (type) {
            case "java.util.List": 
            case "java.util.LinkedList": 
            case "java.util.ArrayList": 
            case "java.util.Set": 
            case "java.util.TreeSet": 
            case "java.util.HashSet": 
            case "java.util.SortedSet": 
            case "java.util.Collection": 
            case "java.util.ArrayDeque": 
            case "java.util.PriorityQueue": 
            case "java.util.EnumSet": {
                return true;
            }
        }
        return false;
    }

    public static boolean isMap(String type) {
        switch (type) {
            case "java.util.Map": 
            case "java.util.SortedMap": 
            case "java.util.TreeMap": 
            case "java.util.LinkedHashMap": 
            case "java.util.HashMap": 
            case "java.util.concurrent.ConcurrentHashMap": 
            case "java.util.concurrent.ConcurrentMap": 
            case "java.util.Properties": 
            case "java.util.Hashtable": {
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(String type) {
        return type.endsWith("[]");
    }

    public static boolean isJSR303Required(String annotationSimpleName) {
        switch (annotationSimpleName) {
            case "NotNull": 
            case "NotEmpty": 
            case "NotBlank": 
            case "Required": {
                return true;
            }
        }
        return false;
    }

    public static boolean isIgnoreTag(String tagName) {
        switch (tagName) {
            case "ignore": {
                return true;
            }
        }
        return false;
    }

    public static boolean isFileDownloadResource(String typeName) {
        switch (typeName) {
            case "org.springframework.core.io.Resource": 
            case "org.springframework.core.io.InputStreamSource": 
            case "org.springframework.core.io.ByteArrayResource": 
            case "org.noear.solon.core.handle.DownloadedFile": {
                return true;
            }
        }
        return false;
    }

    public static boolean isMvcIgnoreParams(String paramType, List<String> ignoreParams) {
        if (CollectionUtil.isNotEmpty(ignoreParams) && ignoreParams.contains(paramType)) {
            return true;
        }
        switch (paramType) {
            case "org.springframework.ui.Model": 
            case "org.springframework.ui.ModelMap": 
            case "org.springframework.web.servlet.ModelAndView": 
            case "org.springframework.web.servlet.mvc.support.RedirectAttributesModelMap": 
            case "org.springframework.validation.BindingResult": 
            case "javax.servlet.http.HttpServletRequest": 
            case "javax.servlet.http.HttpServlet": 
            case "javax.servlet.http.HttpSession": 
            case "javax.servlet.http.HttpServletResponse": 
            case "jakarta.servlet.http.HttpServletRequest": 
            case "jakarta.servlet.http.HttpServlet": 
            case "jakarta.servlet.http.HttpSession": 
            case "jakarta.servlet.http.HttpServletResponse": 
            case "org.springframework.web.context.request.WebRequest": 
            case "org.springframework.web.reactive.function.server.ServerRequest": 
            case "org.springframework.web.multipart.MultipartHttpServletRequest": 
            case "org.springframework.http.HttpHeaders": 
            case "org.springframework.core.io.Resource": 
            case "org.springframework.core.io.InputStreamSource": 
            case "org.springframework.core.io.ByteArrayResource": 
            case "org.noear.solon.core.handle.Context": 
            case "org.noear.solon.core.handle.ModelAndView": {
                return true;
            }
        }
        return false;
    }

    public static boolean isIgnoreFieldTypes(String typeName) {
        switch (typeName) {
            case "org.slf4j.Logger": 
            case "org.apache.ibatis.logging.Log": 
            case "java.lang.Class": {
                return true;
            }
        }
        return false;
    }

    public static boolean isFile(String typeName) {
        switch (typeName) {
            case "org.springframework.web.multipart.MultipartFile": 
            case "org.springframework.web.multipart.MultipartFile[]": 
            case "java.util.List<org.springframework.web.multipart.MultipartFile>": 
            case "org.springframework.web.multipart.commons.CommonsMultipartFile": 
            case "org.springframework.web.multipart.commons.CommonsMultipartFile[]": 
            case "java.util.List<org.springframework.web.multipart.commons.CommonsMultipartFile>": 
            case "javax.servlet.http.Part": 
            case "javax.servlet.http.Part[]": 
            case "jakarta.servlet.http.Part": 
            case "jakarta.servlet.http.Part[]": 
            case "java.util.List<jakarta.servlet.http.Part>": 
            case "org.noear.solon.core.handle.UploadedFile": 
            case "org.noear.solon.core.handle.DownloadedFile": {
                return true;
            }
        }
        return false;
    }

    public static boolean isReactor(String typeName) {
        switch (typeName) {
            case "reactor.core.publisher.Mono": 
            case "reactor.core.publisher.Flux": {
                return true;
            }
        }
        return false;
    }

    public static boolean ignoreSpringMvcParamWithAnnotation(String annotation) {
        switch (annotation) {
            case "SessionAttribute": 
            case "RequestAttribute": 
            case "RequestHeader": {
                return true;
            }
        }
        return false;
    }

    public static boolean ignoreSolonMvcParamWithAnnotation(String annotation) {
        switch (annotation) {
            case "Header": {
                return true;
            }
        }
        return false;
    }

    public static boolean isClassName(String className) {
        if (StringUtil.isEmpty((String)className) || !className.contains(".")) {
            return false;
        }
        if (ValidateUtil.isContainsChinese((String)className)) {
            return false;
        }
        String classNameTemp = className;
        if (className.contains("<")) {
            int index = className.indexOf("<");
            classNameTemp = className.substring(0, index);
        }
        if (!ValidateUtil.validate((String)classNameTemp, (String)CLASS_PATTERN)) {
            return false;
        }
        if (className.contains("<") && !className.contains(">")) {
            return false;
        }
        return !className.contains(">") || className.contains("<");
    }

    public static boolean isIgnoreFieldJson(JavaAnnotation annotation, Boolean isResp) {
        AnnotationValue value;
        String simpleAnnotationName = annotation.getType().getValue();
        if ("JsonIgnore".equals(simpleAnnotationName)) {
            return true;
        }
        if ("JsonProperty".equalsIgnoreCase(simpleAnnotationName) && Objects.nonNull(value = annotation.getProperty("access"))) {
            if ("JsonProperty.Access.READ_ONLY".equals(value.getParameterValue()) && !isResp.booleanValue()) {
                return true;
            }
            if ("JsonProperty.Access.WRITE_ONLY".equals(value.getParameterValue()) && isResp.booleanValue()) {
                return true;
            }
        }
        if ("JSONField".equals(simpleAnnotationName)) {
            AnnotationValue serialize = annotation.getProperty("serialize");
            AnnotationValue deserialize = annotation.getProperty("deserialize");
            if (!isResp.booleanValue() && Objects.nonNull(deserialize) && Boolean.FALSE.toString().equals(deserialize.toString())) {
                return true;
            }
            if (isResp.booleanValue() && Objects.nonNull(serialize) && Boolean.FALSE.toString().equals(serialize.toString())) {
                return true;
            }
        }
        return false;
    }
}

