/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.utils;

import com.ly.doc.constants.DocValidatorAnnotationEnum;
import com.ly.doc.model.CustomField;
import com.ly.doc.model.DocJavaField;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.ly.doc.utils.ParamUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JavaFieldUtil {
    private static final int PUBLIC_STATIC_FINAL = 25;

    public static boolean checkGenerics(List<DocJavaField> fields) {
        for (DocJavaField field : fields) {
            if (field.getJavaField().getType().getFullyQualifiedName().length() != 1) continue;
            return true;
        }
        return false;
    }

    public static void buildCustomField(StringBuilder data0, String typeSimpleName, CustomField customField) {
        Object val = customField.getValue();
        if (Objects.nonNull(val)) {
            if (DocUtil.javaPrimaryType(typeSimpleName)) {
                data0.append(val).append(",");
            } else {
                data0.append(DocUtil.handleJsonStr(String.valueOf(val))).append(",");
            }
        }
    }

    public static String createMockValue(Map<String, String> paramsComments, String paramName, String typeName, String simpleTypeName) {
        String mockValue = "";
        if (JavaClassValidateUtil.isPrimitive(typeName) && StringUtil.isEmpty((String)(mockValue = Objects.nonNull(mockValue = paramsComments.get(paramName)) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1) : ""))) {
            mockValue = DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName, Boolean.TRUE);
        }
        return ParamUtil.formatMockValue(mockValue);
    }

    public static String getParamMaxLength(List<JavaAnnotation> annotations) {
        String maxLength = "";
        for (JavaAnnotation annotation : annotations) {
            String simpleAnnotationName = annotation.getType().getValue();
            AnnotationValue annotationValue = null;
            if ("Size".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("max");
            }
            if ("Length".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("max");
            }
            if (!Objects.nonNull(annotationValue)) continue;
            maxLength = annotationValue.toString();
        }
        return maxLength;
    }

    public static String getJsrComment(boolean showValidation, ClassLoader classLoader, List<JavaAnnotation> annotations) {
        if (!showValidation) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (JavaAnnotation annotation : annotations) {
            Map values = annotation.getPropertyMap();
            String name = annotation.getType().getValue();
            if ("NotBlank".equals(name) || "NotEmpty".equals(name) || "NotNull".equals(name) || "Null".equals(name) || "Validated".equals(name) || !DocValidatorAnnotationEnum.listValidatorAnnotations().contains(name)) continue;
            sb.append(name).append("(");
            int j = 0;
            for (Map.Entry m : values.entrySet()) {
                String value = DocUtil.resolveAnnotationValue(classLoader, (AnnotationValue)m.getValue());
                sb.append((String)m.getKey()).append("=").append(StringUtil.removeDoubleQuotes((String)value));
                if (++j >= values.size()) continue;
                sb.append(", ");
            }
            sb.append("); ");
        }
        if (sb.length() < 1) {
            return "";
        }
        if (sb.toString().contains(";")) {
            sb.deleteCharAt(sb.lastIndexOf(";"));
        }
        return "\nValidation[" + sb + "]";
    }

    public static String convertToSimpleTypeName(String str) {
        String regex = "\\b\\w+\\.(?=\\w+\\b)";
        return str.replaceAll(regex, "");
    }

    public static String getConstantsFieldValue(ClassLoader classLoader, JavaClass javaClass, String fieldName) {
        try {
            Field[] fields;
            Class<?> c = Objects.nonNull(classLoader) ? classLoader.loadClass(javaClass.getFullyQualifiedName()) : Class.forName(javaClass.getFullyQualifiedName());
            for (Field f : fields = c.getDeclaredFields()) {
                if ((f.getModifiers() & 0x19) != 25 || !f.getName().equals(fieldName)) continue;
                Object constantValue = f.get(null);
                return null == constantValue ? null : String.valueOf(constantValue);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            return null;
        }
        return null;
    }
}

