/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Objects;

public class JsonUtil {
    public static String toPrettyFormat(String jsonString) {
        if (Objects.isNull(jsonString)) {
            return null;
        }
        if (!jsonString.startsWith("[") && !jsonString.startsWith("{")) {
            return jsonString;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)jsonString);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            return gson.toJson(jsonElement);
        }
        catch (Exception e) {
            return jsonString;
        }
    }

    public static String toPrettyJson(Object src) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson(src);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return (T)new Gson().fromJson(json, clazz);
    }
}

