/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.utils;

import com.ly.doc.constants.ComponentTypeEnum;
import com.ly.doc.constants.TornaConstants;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiParam;
import com.ly.doc.utils.DocUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class OpenApiSchemaUtil {
    public static final String NO_BODY_PARAM = "NO_BODY_PARAM";
    static final Pattern PATTERN = Pattern.compile("[A-Z]\\w+.*?|[A-Z]");

    public static Map<String, Object> primaryTypeSchema(String primaryType) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        return map;
    }

    public static Map<String, Object> mapTypeSchema(String primaryType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "object");
        HashMap<String, String> items = new HashMap<String, String>(16);
        items.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        map.put("additionalProperties", items);
        return map;
    }

    public static Map<String, Object> arrayTypeSchema(String primaryType) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("type", "array");
        HashMap<String, String> items = new HashMap<String, String>(16);
        items.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        map.put("items", items);
        return map;
    }

    public static String getClassNameFromParams(List<ApiParam> apiParams) {
        ComponentTypeEnum componentTypeEnum = ApiConfig.getInstance().getComponentType();
        if (componentTypeEnum.equals((Object)ComponentTypeEnum.RANDOM)) {
            return DigestUtils.md5Hex((String)TornaConstants.GSON.toJson(apiParams));
        }
        if (CollectionUtil.isNotEmpty(apiParams) && apiParams.size() == 1 && StringUtil.isEmpty((String)apiParams.get(0).getClassName()) && CollectionUtil.isEmpty(apiParams.get(0).getChildren())) {
            return "defaultPrimitive";
        }
        for (ApiParam a : apiParams) {
            if (!StringUtil.isNotEmpty((String)a.getClassName())) continue;
            return OpenApiSchemaUtil.delClassName(a.getClassName());
        }
        return NO_BODY_PARAM;
    }

    public static String delClassName(String className) {
        return String.join((CharSequence)"", OpenApiSchemaUtil.getPatternResult(PATTERN, className));
    }

    public static List<String> getPatternResult(Pattern p, String content) {
        ArrayList<String> matchers = new ArrayList<String>();
        Matcher m = p.matcher(content);
        while (m.find()) {
            matchers.add(m.group());
        }
        return matchers;
    }

    public static List<String> getPatternResult(String rex, String content) {
        Pattern p = Pattern.compile(rex);
        ArrayList<String> matchers = new ArrayList<String>();
        Matcher m = p.matcher(content);
        while (m.find()) {
            matchers.add(m.group());
        }
        return matchers;
    }
}

