/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.utils;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.model.ApiParam;
import com.ly.doc.utils.JavaClassUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ParamUtil {
    public static JavaClass handleSeeEnum(ApiParam param, JavaField javaField, ProjectDocConfigBuilder builder, boolean jsonRequest, Map<String, String> tagsMap, String jsonFormatValue) {
        JavaClass seeEnum = JavaClassUtil.getSeeEnum(javaField, builder);
        if (Objects.isNull(seeEnum)) {
            return null;
        }
        if (Objects.equals(seeEnum.getGenericFullyQualifiedName(), javaField.getType().getGenericFullyQualifiedName())) {
            param.setType("enum");
        }
        Object value = JavaClassUtil.getEnumValue(seeEnum, !jsonRequest);
        param.setValue(StringUtil.removeDoubleQuotes((String)String.valueOf(value)));
        param.setEnumValues(JavaClassUtil.getEnumValues(seeEnum));
        param.setEnumInfo(JavaClassUtil.getEnumInfo(seeEnum, builder));
        if (StringUtil.isNotEmpty((String)jsonFormatValue)) {
            param.setValue(jsonFormatValue);
            param.setEnumValues(IntStream.rangeClosed(0, param.getEnumValues().size() - 1).mapToObj(Integer::toString).collect(Collectors.toList()));
        }
        if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
            param.setValue(tagsMap.get("mock"));
        }
        return seeEnum;
    }

    public static String formatMockValue(String mock) {
        if (StringUtil.isEmpty((String)mock)) {
            return mock;
        }
        return mock.replaceAll("\\\\", "");
    }

    public static List<String> extractQualifiedName(List<ApiParam> paramList) {
        if (CollectionUtil.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        HashSet<String> set = new HashSet<String>();
        for (ApiParam param : paramList) {
            String className = param.getClassName();
            if (StringUtil.isEmpty((String)className)) continue;
            int index = className.indexOf("<");
            if (index > -1) {
                className = className.substring(0, index);
            }
            set.add(className);
        }
        return new ArrayList<String>(set);
    }
}

