/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.utils;

import com.ly.doc.constants.Methods;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.FormData;
import com.ly.doc.model.request.ApiRequestExample;
import com.ly.doc.model.request.CurlRequest;
import com.ly.doc.utils.CurlUtil;
import com.ly.doc.utils.DocUrlUtil;
import com.ly.doc.utils.DocUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RequestExampleUtil {
    public static void setExampleBody(ApiMethodDoc apiMethodDoc, ApiRequestExample requestExample, List<FormData> formDataList, Map<String, String> pathParamsMap, Map<String, String> queryParamsMap) {
        String methodType = apiMethodDoc.getType();
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        Map<Boolean, List<FormData>> formDataGroupMap = formDataList.stream().collect(Collectors.groupingBy(e -> Objects.equals(e.getType(), "file")));
        List fileFormDataList = formDataGroupMap.getOrDefault(Boolean.TRUE, new ArrayList());
        Map<String, String> formDataToMap = DocUtil.formDataToMap(formDataList);
        queryParamsMap.putAll(formDataToMap);
        if (Methods.POST.getValue().equals(methodType) || Methods.PUT.getValue().equals(methodType)) {
            String exampleBody;
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String body = UrlUtil.urlJoin((String)"", queryParamsMap).replace("?", "");
            String url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            if (requestExample.isJson()) {
                if (StringUtil.isNotEmpty((String)body)) {
                    url = url + "?" + body;
                }
                CurlRequest curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            } else {
                CurlRequest curlRequest = StringUtil.isNotEmpty((String)body) ? CurlRequest.builder().setBody(body).setContentType(apiMethodDoc.getContentType()).setFileFormDataList(fileFormDataList).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url) : CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setFileFormDataList(fileFormDataList).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            }
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            String url = DocUrlUtil.formatRequestUrl(pathParamsMap, queryParamsMap, apiMethodDoc.getServerUrl(), path);
            CurlRequest curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
            String exampleBody = CurlUtil.toCurl(curlRequest);
            requestExample.setExampleBody(exampleBody).setJsonBody(requestExample.isJson() ? requestExample.getJsonBody() : "").setUrl(url);
        }
    }
}

