/*
 * Decompiled with CFR 0.152.
 */
package com.hw.serpapi;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.hw.serpapi.ParameterStringBuilder;
import com.hw.serpapi.SerpApiSearchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SerpApiHttpClient {
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    public static String VERSION = "2.0.3";
    public static String BACKEND = "https://serpapi.com";
    private static Gson gson = new Gson();
    public String path;

    public SerpApiHttpClient(String path) {
        this.path = path;
    }

    protected HttpURLConnection buildConnection(String path, Map<String, String> parameter) throws SerpApiSearchException {
        HttpURLConnection con;
        try {
            this.allowHTTPS();
            String query = ParameterStringBuilder.getParamsString(parameter);
            URL url = new URL(BACKEND + path + "?" + query);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
        }
        catch (IOException e) {
            throw new SerpApiSearchException(e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SerpApiSearchException(e);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            throw new SerpApiSearchException(e);
        }
        String outputFormat = parameter.get("output");
        if (outputFormat == null) {
            if (path.startsWith("/search?")) {
                throw new SerpApiSearchException("output format must be defined: " + path);
            }
        } else if (outputFormat.startsWith("json")) {
            con.setRequestProperty("Content-Type", "application/json");
        }
        con.setConnectTimeout(this.getHttpConnectionTimeout());
        con.setReadTimeout(this.getHttpReadTimeout());
        con.setDoOutput(true);
        return con;
    }

    private void allowHTTPS() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    public String getResults(Map<String, String> parameter) throws SerpApiSearchException {
        HttpURLConnection con = this.buildConnection(this.path, parameter);
        int statusCode = -1;
        InputStream is = null;
        BufferedReader in = null;
        try {
            statusCode = con.getResponseCode();
            is = statusCode == 200 ? con.getInputStream() : con.getErrorStream();
            InputStreamReader reader = new InputStreamReader(is);
            in = new BufferedReader(reader);
        }
        catch (IOException e) {
            throw new SerpApiSearchException(e);
        }
        StringBuffer content = new StringBuffer();
        try {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            throw new SerpApiSearchException(e);
        }
        con.disconnect();
        if (statusCode != 200) {
            this.triggerSerpApiClientException(content.toString());
        }
        return content.toString();
    }

    protected void triggerSerpApiClientException(String content) throws SerpApiSearchException {
        String errorMessage;
        try {
            JsonObject element = (JsonObject)gson.fromJson(content, JsonObject.class);
            errorMessage = element.get("error").getAsString();
        }
        catch (Exception e) {
            throw new AssertionError((Object)("invalid response format: " + content));
        }
        throw new SerpApiSearchException(errorMessage);
    }

    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public void setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }
}

