/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.antlr4;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.antlr4.EnhanceElasticsearchLexer;
import io.github.iamazy.elasticsearch.dsl.antlr4.ParserErrorStrategy;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticSqlParseResult;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.StringUtils;

public class Walker {
    private final String sql;
    private ElasticSqlParseResult parseResult;

    public Walker(String sql) {
        this.sql = sql;
        this.parseResult = new ElasticSqlParseResult();
    }

    public ElasticSqlParseResult getParseResult() {
        return this.parseResult;
    }

    public ElasticsearchParser.SqlContext buildAntlrTree() {
        if (StringUtils.isBlank((CharSequence)this.sql)) {
            throw new ElasticSql2DslException("blank sql is not allowed");
        }
        CodePointCharStream stream = CharStreams.fromString((String)this.sql);
        EnhanceElasticsearchLexer lexer = new EnhanceElasticsearchLexer((CharStream)stream);
        ElasticsearchParser parser = new ElasticsearchParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ParserErrorStrategy strategy = new ParserErrorStrategy(this.sql);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        parser.setErrorHandler((ANTLRErrorStrategy)strategy);
        return parser.sql();
    }
}

