/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.model;

import io.github.iamazy.elasticsearch.dsl.cons.CoreConstants;
import io.github.iamazy.elasticsearch.dsl.elastic.HighlightBuilders;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlOperation;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class ElasticSqlParseResult {
    private int from = 0;
    private int size = 15;
    private List<String> indices = new ArrayList<String>(0);
    private Map<String, String> aliasMap = new HashMap<String, String>(0);
    private SqlOperation sqlOperation = SqlOperation.SELECT;
    private transient boolean trackTotalHits = false;
    private Set<String> highlighter = new HashSet<String>(0);
    private List<String> routingBy = new ArrayList<String>(0);
    private List<String> includeFields = new ArrayList<String>(0);
    private List<String> excludeFields = new ArrayList<String>(0);
    private transient QueryBuilder whereCondition = QueryBuilders.matchAllQuery();
    private transient String distinctName;
    private transient List<SortBuilder> orderBy = new ArrayList<SortBuilder>(0);
    private transient List<AggregationBuilder> groupBy = new ArrayList<AggregationBuilder>(0);
    private transient SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
    private transient SearchRequest searchRequest;
    private transient ReindexRequest reindexRequest;
    private transient IndexRequest indexRequest;
    private transient UpdateRequest updateRequest;
    private transient UpdateByQueryRequest updateByQueryRequest;
    private transient DeleteRequest deleteRequest;
    private transient DeleteByQueryRequest deleteByQueryRequest;
    private GetMappingsRequest mappingsRequest;
    private GetFieldMappingsRequest fieldMappingsRequest;

    public void setSqlOperation(SqlOperation sqlOperation) {
        this.sqlOperation = sqlOperation;
    }

    public SqlOperation getSqlOperation() {
        return this.sqlOperation;
    }

    public int getFrom() {
        return this.from;
    }

    public ElasticSqlParseResult setFrom(int from) {
        this.from = from;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public ElasticSqlParseResult setSize(int size) {
        this.size = size;
        return this;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    public void trackTotalHits(boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
    }

    public Set<String> getHighlighter() {
        return this.highlighter;
    }

    public List<String> getRoutingBy() {
        return this.routingBy;
    }

    public List<String> getIncludeFields() {
        return this.includeFields;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }

    public QueryBuilder getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(QueryBuilder whereCondition) {
        this.whereCondition = whereCondition;
    }

    public ReindexRequest getReindexRequest() {
        return this.reindexRequest;
    }

    public void setReindexRequest(ReindexRequest reindexRequest) {
        this.reindexRequest = reindexRequest;
    }

    public IndexRequest getIndexRequest() {
        return this.indexRequest;
    }

    public void setIndexRequest(IndexRequest indexRequest) {
        this.indexRequest = indexRequest;
    }

    public UpdateByQueryRequest getUpdateByQueryRequest() {
        return this.updateByQueryRequest;
    }

    public void setUpdateByQueryRequest(UpdateByQueryRequest updateByQueryRequest) {
        this.updateByQueryRequest = updateByQueryRequest;
    }

    public UpdateRequest getUpdateRequest() {
        return this.updateRequest;
    }

    public void setUpdateRequest(UpdateRequest updateRequest) {
        this.updateRequest = updateRequest;
    }

    public DeleteByQueryRequest getDeleteByQueryRequest() {
        return this.deleteByQueryRequest;
    }

    public void setDeleteByQueryRequest(DeleteByQueryRequest deleteByQueryRequest) {
        this.deleteByQueryRequest = deleteByQueryRequest;
    }

    public DeleteRequest getDeleteRequest() {
        return this.deleteRequest;
    }

    public void setDeleteRequest(DeleteRequest deleteRequest) {
        this.deleteRequest = deleteRequest;
    }

    public SearchRequest getSearchRequest() {
        if (this.searchRequest == null) {
            this.searchRequest = this.toRequest();
        }
        return this.searchRequest;
    }

    public List<SortBuilder> getOrderBy() {
        return this.orderBy;
    }

    public List<AggregationBuilder> getGroupBy() {
        return this.groupBy;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public void setDistinctName(String distinctName) {
        this.distinctName = distinctName;
    }

    public GetMappingsRequest getMappingsRequest() {
        return this.mappingsRequest;
    }

    public void setMappingsRequest(GetMappingsRequest mappingsRequest) {
        this.mappingsRequest = mappingsRequest;
    }

    public GetFieldMappingsRequest getFieldMappingsRequest() {
        return this.fieldMappingsRequest;
    }

    public void setFieldMappingsRequest(GetFieldMappingsRequest fieldMappingsRequest) {
        this.fieldMappingsRequest = fieldMappingsRequest;
    }

    private SearchRequest toRequest() {
        SearchRequest searchRequest = new SearchRequest();
        List<String> indexList = this.indices.parallelStream().map(StringManager::removeStringSymbol).collect(Collectors.toList());
        if (!CollectionUtils.isNotEmpty(indexList)) {
            throw new ElasticSql2DslException("[syntax error] indices name must be set");
        }
        searchRequest.indices(indexList.toArray(new String[0]));
        this.searchSourceBuilder.from(Math.max(this.from, 0));
        this.searchSourceBuilder.size(Math.max(this.size, 0));
        this.searchSourceBuilder.trackTotalHits(this.trackTotalHits);
        if (CollectionUtils.isNotEmpty(this.highlighter)) {
            HighlightBuilder highlightBuilder = HighlightBuilders.highlighter(this.highlighter);
            this.searchSourceBuilder.highlighter(highlightBuilder);
        }
        this.searchSourceBuilder.query(this.whereCondition);
        if (StringUtils.isNotBlank((CharSequence)this.distinctName)) {
            this.searchSourceBuilder.collapse(new CollapseBuilder(this.distinctName));
        }
        if (CollectionUtils.isNotEmpty(this.orderBy)) {
            for (SortBuilder sortBuilder : this.orderBy) {
                this.searchSourceBuilder.sort(sortBuilder);
            }
        }
        this.searchSourceBuilder.fetchSource(this.includeFields.toArray(new String[0]), this.excludeFields.toArray(new String[0]));
        if (CollectionUtils.isNotEmpty(this.routingBy)) {
            searchRequest.routing(this.routingBy.toArray(new String[0]));
        }
        if (CollectionUtils.isNotEmpty(this.groupBy)) {
            for (AggregationBuilder aggItem : this.groupBy) {
                this.searchSourceBuilder.aggregation(aggItem);
            }
        }
        return searchRequest.source(this.searchSourceBuilder);
    }

    public String toDsl(SearchRequest searchRequest) {
        return searchRequest.source().toString();
    }

    public String toPrettyDsl(SearchRequest searchRequest) {
        try {
            Object o = CoreConstants.OBJECT_MAPPER.readValue(this.toDsl(searchRequest), Object.class);
            return CoreConstants.OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (IOException e) {
            throw new RuntimeException("Elasticsearch Dsl\u89e3\u6790\u51fa\u9519!!!");
        }
    }
}

