/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.model;

import com.google.common.collect.Lists;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlBoolOperator;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlConditionType;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import java.util.List;

public class SqlCondition {
    private SqlConditionType conditionType;
    private SqlBoolOperator operator;
    private List<AtomicQuery> queryList;

    public SqlCondition(AtomicQuery query) {
        this(query, SqlConditionType.Atomic);
    }

    public SqlCondition(List<AtomicQuery> queryList, SqlBoolOperator operator) {
        this.queryList = queryList;
        this.conditionType = SqlConditionType.Combine;
        this.operator = operator;
    }

    public SqlCondition(AtomicQuery query, SqlConditionType conditionType) {
        this.queryList = Lists.newArrayList((Object[])new AtomicQuery[]{query});
        this.conditionType = conditionType;
    }

    public List<AtomicQuery> getQueryList() {
        return this.queryList;
    }

    public SqlBoolOperator getOperator() {
        return this.operator;
    }

    public SqlConditionType getConditionType() {
        return this.conditionType;
    }
}

