/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlBoolOperator;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlConditionType;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.model.SqlCondition;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact.BinaryQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.nested.NestedQueryParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class BoolExpressionParser {
    private final BinaryQueryParser binaryQueryParser;
    private final NestedQueryParser nestedQueryParser;
    public Set<String> highlighter = new HashSet<String>(0);

    public BoolExpressionParser() {
        this.binaryQueryParser = new BinaryQueryParser();
        this.nestedQueryParser = new NestedQueryParser();
    }

    public QueryBuilder parseBoolQueryExpr(ElasticsearchParser.ExpressionContext expressionContext) {
        SqlCondition sqlCondition = this.recursiveParseBoolQueryExpr(expressionContext);
        SqlBoolOperator operator = sqlCondition.getOperator();
        if (SqlConditionType.Atomic == sqlCondition.getConditionType()) {
            operator = SqlBoolOperator.AND;
        }
        if (sqlCondition.getQueryList().size() > 1) {
            return this.mergeAtomicQuery(sqlCondition.getQueryList(), operator);
        }
        this.highlighter.addAll(sqlCondition.getQueryList().get(0).getHighlighter());
        return sqlCondition.getQueryList().get(0).getQueryBuilder();
    }

    private void combineQueryBuilder(List<AtomicQuery> combiner, SqlCondition sqlCondition, SqlBoolOperator boolOperator) {
        if (SqlConditionType.Atomic == sqlCondition.getConditionType() || sqlCondition.getOperator() == boolOperator) {
            for (AtomicQuery atomicQuery : sqlCondition.getQueryList()) {
                this.highlighter.addAll(atomicQuery.getHighlighter());
                combiner.add(atomicQuery);
            }
        } else {
            BoolQueryBuilder boolQueryBuilder = this.mergeAtomicQuery(sqlCondition.getQueryList(), sqlCondition.getOperator());
            combiner.add(new AtomicQuery((QueryBuilder)boolQueryBuilder));
        }
    }

    private SqlCondition recursiveParseBoolQueryExpr(ElasticsearchParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof ElasticsearchParser.BinaryContext) {
            ElasticsearchParser.BinaryContext binaryContext = (ElasticsearchParser.BinaryContext)expressionContext;
            if (binaryContext.operator != null) {
                SqlBoolOperator boolOperator;
                int operatorType = binaryContext.operator.getType();
                if (operatorType == 24 || operatorType == 127) {
                    boolOperator = SqlBoolOperator.AND;
                } else if (operatorType == 25 || operatorType == 125) {
                    boolOperator = SqlBoolOperator.OR;
                } else {
                    AtomicQuery atomicQuery = this.binaryQueryParser.parseExpressionContext(expressionContext);
                    this.highlighter.addAll(atomicQuery.getHighlighter());
                    return new SqlCondition(atomicQuery, SqlConditionType.Atomic);
                }
                SqlCondition leftCondition = this.recursiveParseBoolQueryExpr(binaryContext.leftExpr);
                SqlCondition rightCondition = this.recursiveParseBoolQueryExpr(binaryContext.rightExpr);
                ArrayList queryList = Lists.newArrayList();
                this.combineQueryBuilder(queryList, leftCondition, boolOperator);
                this.combineQueryBuilder(queryList, rightCondition, boolOperator);
                return new SqlCondition(queryList, boolOperator);
            }
            AtomicQuery atomicQuery = this.binaryQueryParser.parseExpressionContext(expressionContext);
            this.highlighter.addAll(atomicQuery.getHighlighter());
            return new SqlCondition(atomicQuery, SqlConditionType.Atomic);
        }
        if (expressionContext instanceof ElasticsearchParser.NestedContext) {
            ElasticsearchParser.NestedContext nestedContext = (ElasticsearchParser.NestedContext)expressionContext;
            return new SqlCondition(this.nestedQueryParser.parse(nestedContext), SqlConditionType.Atomic);
        }
        AtomicQuery atomicQuery = this.binaryQueryParser.parseExpressionContext(expressionContext);
        this.highlighter.addAll(atomicQuery.getHighlighter());
        return new SqlCondition(atomicQuery, SqlConditionType.Atomic);
    }

    private BoolQueryBuilder mergeAtomicQuery(List<AtomicQuery> queryList, SqlBoolOperator operator) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ArrayListMultimap listMultimap = ArrayListMultimap.create();
        for (AtomicQuery atomicQuery : queryList) {
            if (CollectionUtils.isNotEmpty(atomicQuery.getHighlighter())) {
                this.highlighter.addAll(atomicQuery.getHighlighter());
            }
            if (operator == SqlBoolOperator.AND) {
                if (atomicQuery.getQueryBuilder() instanceof BoolQueryBuilder) {
                    BoolQueryBuilder boolQuery = (BoolQueryBuilder)atomicQuery.getQueryBuilder();
                    if (CollectionUtils.isNotEmpty((Collection)boolQuery.must())) {
                        boolQueryBuilder.must().addAll(boolQuery.must());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)boolQuery.mustNot())) {
                        boolQueryBuilder.mustNot().addAll(boolQuery.mustNot());
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)boolQuery.should())) continue;
                    boolQueryBuilder.should().addAll(boolQuery.should());
                    continue;
                }
                boolQueryBuilder.must(atomicQuery.getQueryBuilder());
                continue;
            }
            if (operator == SqlBoolOperator.OR) {
                boolQueryBuilder.should(atomicQuery.getQueryBuilder());
                continue;
            }
            listMultimap.put((Object)atomicQuery, (Object)atomicQuery.getQueryBuilder());
        }
        if (boolQueryBuilder.should().size() > 1) {
            boolQueryBuilder.minimumShouldMatch(1);
        }
        return boolQueryBuilder;
    }
}

