/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticDslContext;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.CollectionUtils;

public class QueryRoutingsParser
implements QueryParser {
    @Override
    public void parse(ElasticDslContext dslContext) {
        ArrayList<String> routings = new ArrayList<String>(0);
        if (dslContext.getSqlContext().selectOperation() != null) {
            ElasticsearchParser.SelectOperationContext selectOperationContext = dslContext.getSqlContext().selectOperation();
            this.addRouting(selectOperationContext.routingClause(), routings);
        } else if (dslContext.getSqlContext().insertOperation() != null) {
            ElasticsearchParser.InsertOperationContext insertOperationContext = dslContext.getSqlContext().insertOperation();
            this.addRouting(insertOperationContext.routingClause(), routings);
        } else if (dslContext.getSqlContext().updateOperation() != null) {
            ElasticsearchParser.UpdateOperationContext updateOperationContext = dslContext.getSqlContext().updateOperation();
            this.addRouting(updateOperationContext.routingClause(), routings);
        } else if (dslContext.getSqlContext().deleteOperation() != null) {
            ElasticsearchParser.DeleteOperationContext deleteOperationContext = dslContext.getSqlContext().deleteOperation();
            this.addRouting(deleteOperationContext.routingClause(), routings);
        }
        if (CollectionUtils.isNotEmpty(routings)) {
            dslContext.getParseResult().getRoutingBy().addAll(routings);
        }
    }

    private void addRouting(ElasticsearchParser.RoutingClauseContext routingClauseContext, List<String> routings) {
        if (routingClauseContext != null) {
            for (TerminalNode node : routingClauseContext.STRING()) {
                routings.add(StringManager.removeStringSymbol(node.getText()));
            }
        }
    }
}

