/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticDslContext;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.GroupByQueryParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class QuerySelectFieldsParser
implements QueryParser {
    @Override
    public void parse(ElasticDslContext dslContext) {
        if (dslContext.getSqlContext().selectOperation() != null) {
            if (dslContext.getSqlContext().selectOperation().groupByClause() == null) {
                this.parseNotGroupByClause(dslContext);
            } else {
                ElasticsearchParser.GroupByClauseContext groupByClauseContext = dslContext.getSqlContext().selectOperation().groupByClause();
                this.parseGroupByClause(groupByClauseContext, dslContext);
            }
        }
    }

    private void parseNotGroupByClause(ElasticDslContext dslContext) {
        ElasticsearchParser.SelectOperationContext selectOperationContext = dslContext.getSqlContext().selectOperation();
        ElasticsearchParser.FieldListContext fieldListContext = selectOperationContext.fieldList();
        if (fieldListContext.nameOperand().size() > 0) {
            ArrayList<String> includeFields = new ArrayList<String>(0);
            ArrayList<String> excludeFields = new ArrayList<String>(0);
            for (ElasticsearchParser.NameOperandContext fieldName : fieldListContext.nameOperand()) {
                if (fieldName.exclude != null) {
                    if (fieldName.fieldName instanceof ElasticsearchParser.FieldNameContext) {
                        excludeFields.add(((ElasticsearchParser.FieldNameContext)fieldName.fieldName).field.getText());
                        continue;
                    }
                    excludeFields.add(fieldName.fieldName.getText());
                    continue;
                }
                if (fieldName.fieldName instanceof ElasticsearchParser.FieldNameContext) {
                    ElasticsearchParser.FieldNameContext fieldNameContext = (ElasticsearchParser.FieldNameContext)fieldName.fieldName;
                    if (fieldNameContext.highlighter != null) {
                        dslContext.getParseResult().getHighlighter().add(fieldNameContext.field.getText());
                    }
                    if (fieldName.alias != null) {
                        dslContext.getParseResult().getAliasMap().put(fieldName.alias.getText(), fieldName.fieldName.getText());
                    }
                    includeFields.add(fieldNameContext.field.getText());
                    continue;
                }
                if (fieldName.fieldName instanceof ElasticsearchParser.DistinctNameContext) {
                    ElasticsearchParser.DistinctNameContext distinctNameContext = (ElasticsearchParser.DistinctNameContext)fieldName.fieldName;
                    String distinctName = distinctNameContext.fieldName.getText();
                    if (distinctNameContext.fieldName instanceof ElasticsearchParser.FieldNameContext) {
                        ElasticsearchParser.FieldNameContext fieldNameContext = (ElasticsearchParser.FieldNameContext)distinctNameContext.fieldName;
                        if (fieldNameContext.highlighter != null) {
                            distinctName = fieldNameContext.field.getText();
                            dslContext.getParseResult().getHighlighter().add(distinctName);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)dslContext.getParseResult().getDistinctName())) {
                        dslContext.getParseResult().setDistinctName(distinctName);
                    }
                    includeFields.add(distinctName);
                    continue;
                }
                includeFields.add(fieldName.fieldName.getText());
            }
            if (CollectionUtils.isNotEmpty(includeFields)) {
                dslContext.getParseResult().getIncludeFields().addAll(includeFields);
            }
            if (CollectionUtils.isNotEmpty(excludeFields)) {
                dslContext.getParseResult().getExcludeFields().addAll(excludeFields);
            }
        }
    }

    private void parseGroupByClause(ElasticsearchParser.GroupByClauseContext groupByClauseContext, ElasticDslContext dslContext) {
        String field;
        dslContext.getParseResult().setSize(0);
        List<String> groupByFields = groupByClauseContext.ID().stream().map(ParseTree::getText).collect(Collectors.toList());
        ElasticsearchParser.FieldListContext fieldListContext = dslContext.getSqlContext().selectOperation().fieldList();
        GroupByQueryParser groupByQueryParser = new GroupByQueryParser();
        HashMap aggregationMap = new HashMap(0);
        for (ElasticsearchParser.NameOperandContext nameOperandContext : fieldListContext.nameOperand()) {
            if (nameOperandContext.fieldName instanceof ElasticsearchParser.FieldNameContext) {
                ElasticsearchParser.FieldNameContext fieldNameContext = (ElasticsearchParser.FieldNameContext)nameOperandContext.fieldName;
                this.checkGroupByField(fieldNameContext.field.getText(), groupByFields);
            } else if (nameOperandContext.fieldName instanceof ElasticsearchParser.FunctionNameContext) {
                ElasticsearchParser.FunctionNameContext functionNameContext = (ElasticsearchParser.FunctionNameContext)nameOperandContext.fieldName;
                field = functionNameContext.params.identity(0).ID().getText();
                this.checkGroupByField(field, groupByFields);
                int idx = groupByFields.indexOf(field);
                if (aggregationMap.containsKey(idx)) {
                    ((Set)aggregationMap.get(idx)).add(groupByQueryParser.parse(functionNameContext.functionName.getText(), field, new Object[0]));
                } else {
                    HashSet<AggregationBuilder> hashSet = new HashSet<AggregationBuilder>(0);
                    hashSet.add(groupByQueryParser.parse(functionNameContext.functionName.getText(), field, new Object[0]));
                    aggregationMap.put(idx, hashSet);
                }
            } else {
                throw new ElasticSql2DslException("only support field or groupBy function in groupBy syntax");
            }
            if (nameOperandContext.alias == null) continue;
            dslContext.getParseResult().getAliasMap().put(nameOperandContext.alias.getText(), nameOperandContext.fieldName.getText());
        }
        if (groupByFields.size() > 0) {
            TermsAggregationBuilder aggregationBuilder = null;
            ArrayList<TermsAggregationBuilder> aggregationBuilders = new ArrayList<TermsAggregationBuilder>(0);
            for (int i = groupByFields.size() - 1; i >= 0; --i) {
                field = groupByFields.get(i);
                if (aggregationBuilder == null) {
                    aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)("terms_" + field)).field(field)).size(5000);
                    aggregationBuilders.add(aggregationBuilder);
                    if (!aggregationMap.containsKey(i)) continue;
                    aggregationBuilders.addAll((Collection)aggregationMap.get(i));
                    continue;
                }
                aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)("terms_" + field)).field(field)).size(5000);
                for (AggregationBuilder aggregationBuilder2 : aggregationBuilders) {
                    aggregationBuilder.subAggregation(aggregationBuilder2);
                }
                aggregationBuilders.clear();
                if (aggregationMap.containsKey(i)) {
                    aggregationBuilders.addAll((Collection)aggregationMap.get(i));
                }
                aggregationBuilders.add(aggregationBuilder);
            }
            dslContext.getParseResult().getGroupBy().addAll(aggregationBuilders);
        }
    }

    private void checkGroupByField(String field, List<String> fields) {
        if (!fields.contains(field)) {
            throw new ElasticSql2DslException("selected field must be contained by groupBy fields");
        }
    }
}

