/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticDslContext;
import io.github.iamazy.elasticsearch.dsl.sql.parser.BoolExpressionParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.score.FunctionScoreQueryParser;
import org.elasticsearch.index.query.QueryBuilder;

public class QueryWhereConditionParser
extends BoolExpressionParser
implements QueryParser {
    @Override
    public void parse(ElasticDslContext dslContext) {
        if (dslContext.getSqlContext().selectOperation() != null) {
            ElasticsearchParser.WhereClauseContext whereClauseContext = dslContext.getSqlContext().selectOperation().whereClause();
            this.parseWhereCondition(dslContext, whereClauseContext);
            if (dslContext.getSqlContext().selectOperation().functionScoreClause() != null) {
                FunctionScoreQueryParser functionScoreQueryParser = new FunctionScoreQueryParser(dslContext.getParseResult().getWhereCondition());
                AtomicQuery atomicQuery = functionScoreQueryParser.parse(dslContext.getSqlContext().selectOperation().functionScoreClause());
                dslContext.getParseResult().setWhereCondition(atomicQuery.getQueryBuilder());
            }
        } else if (dslContext.getSqlContext().deleteOperation() != null) {
            ElasticsearchParser.WhereClauseContext whereClauseContext = dslContext.getSqlContext().deleteOperation().whereClause();
            this.parseWhereCondition(dslContext, whereClauseContext);
        } else if (dslContext.getSqlContext().updateOperation() != null) {
            ElasticsearchParser.WhereClauseContext whereClauseContext = dslContext.getSqlContext().updateOperation().whereClause();
            this.parseWhereCondition(dslContext, whereClauseContext);
        }
    }

    private void parseWhereCondition(ElasticDslContext dslContext, ElasticsearchParser.WhereClauseContext whereClauseContext) {
        if (whereClauseContext != null) {
            ElasticsearchParser.ExpressionContext expression = whereClauseContext.expression();
            QueryBuilder queryBuilder = this.parseBoolQueryExpr(expression);
            dslContext.getParseResult().setWhereCondition(queryBuilder);
            dslContext.getParseResult().getHighlighter().addAll(this.highlighter);
        }
    }
}

