/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.aggs;

import com.google.common.collect.ImmutableList;
import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.AggregateQuery;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticDslContext;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.AggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.bucket.TermsAggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.metrics.AvgAggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.metrics.CardinalityAggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.metrics.MaxAggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.metrics.MinAggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.metrics.SumAggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.metrics.TopHitsAggregationParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.pipeline.DerivativeAggregationParser;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;

public class AggregateByQueryParser
implements QueryParser {
    @Override
    public void parse(ElasticDslContext dslContext) {
        if (dslContext.getSqlContext().selectOperation() != null && dslContext.getSqlContext().selectOperation().aggregateByClause() != null) {
            ElasticsearchParser.AggregateByClauseContext aggregateByClauseContext = dslContext.getSqlContext().selectOperation().aggregateByClause();
            dslContext.getParseResult().getGroupBy().addAll(this.parseAggregationClauseContext(aggregateByClauseContext.aggregationClause()));
        }
    }

    private List<AggregationBuilder> parseAggregationClauseContext(ElasticsearchParser.AggregationClauseContext aggregationClauseContext) {
        ArrayList<AggregationBuilder> aggregationBuilders = new ArrayList<AggregationBuilder>(0);
        if (aggregationClauseContext.aggregateItemClause() != null) {
            ElasticsearchParser.AggregateItemClauseContext aggregateItemClauseContext = aggregationClauseContext.aggregateItemClause();
            return this.parseAggregateItemClauseContext(aggregateItemClauseContext);
        }
        if (aggregationClauseContext.nestedAggregationClause() != null) {
            this.combineNestedLastAggregation(aggregationBuilders, aggregationClauseContext.nestedAggregationClause());
            return aggregationBuilders;
        }
        return aggregationBuilders;
    }

    private List<AggregationBuilder> parseAggregateItemClauseContext(ElasticsearchParser.AggregateItemClauseContext aggregateItemClauseContext) {
        AggregationBuilder o;
        ArrayList<AggregationBuilder> aggregationBuilders = new ArrayList<AggregationBuilder>(0);
        AggregateQuery aggregateQuery = new AggregateQuery();
        for (AggregationParser aggregationParser : AggregateByQueryParser.buildAggregationChain()) {
            aggregationParser.parseAggregateItemClauseContext(aggregateQuery, aggregateItemClauseContext);
        }
        if (aggregateQuery.getAggregationBuilder() == null) {
            throw new ElasticSql2DslException("maybe contains a aggregation which is not support yet");
        }
        if (aggregateItemClauseContext.subAggregationClause().size() > 0 && (o = this.parseSubAggregationClauseContext(aggregateQuery.getAggregationBuilder(), aggregateItemClauseContext.subAggregationClause())) instanceof List) {
            List subAggs = (List)o;
            for (AggregationBuilder agg : subAggs) {
                aggregateQuery.getAggregationBuilder().subAggregation(agg);
            }
        }
        aggregationBuilders.add(aggregateQuery.getAggregationBuilder());
        if (aggregateItemClauseContext.aggregationClause().size() > 0) {
            for (ElasticsearchParser.AggregationClauseContext aggregationClauseContext : aggregateItemClauseContext.aggregationClause()) {
                if (aggregationClauseContext.aggregateItemClause() != null) {
                    aggregationBuilders.addAll(this.parseAggregateItemClauseContext(aggregationClauseContext.aggregateItemClause()));
                }
                if (aggregationClauseContext.nestedAggregationClause() == null) continue;
                this.combineNestedLastAggregation(aggregationBuilders, aggregationClauseContext.nestedAggregationClause());
            }
        }
        return aggregationBuilders;
    }

    private void combineNestedLastAggregation(List<AggregationBuilder> aggregationBuilders, ElasticsearchParser.NestedAggregationClauseContext nestedAggregationClauseContext) {
        aggregationBuilders.add(this.parseNestedAggregationClauseContext(nestedAggregationClauseContext));
        for (int i = 1; i < nestedAggregationClauseContext.aggregationClause().size(); ++i) {
            aggregationBuilders.addAll(this.parseAggregationClauseContext(nestedAggregationClauseContext.aggregationClause(i)));
        }
    }

    private AggregationBuilder parseNestedAggregationClauseContext(ElasticsearchParser.NestedAggregationClauseContext nestedAggregationClauseContext) {
        String nestedPath = nestedAggregationClauseContext.nestedPath.getText();
        String nestedName = "nested_" + nestedPath;
        AbstractAggregationBuilder aggregationBuilder = null;
        if (nestedAggregationClauseContext.aggregationClause(0).nestedAggregationClause() != null) {
            AggregationBuilder nestedAggregationBuilder = this.parseNestedAggregationClauseContext(nestedAggregationClauseContext.aggregationClause(0).nestedAggregationClause());
            aggregationBuilder = AggregationBuilders.nested((String)nestedName, (String)nestedPath).subAggregation(nestedAggregationBuilder);
        } else if (nestedAggregationClauseContext.aggregationClause(0).aggregateItemClause() != null) {
            List<AggregationBuilder> aggregationBuilders = this.parseAggregateItemClauseContext(nestedAggregationClauseContext.aggregationClause(0).aggregateItemClause());
            NestedAggregationBuilder nestAggregationBuilder = AggregationBuilders.nested((String)nestedName, (String)nestedPath);
            for (AggregationBuilder agg : aggregationBuilders) {
                nestAggregationBuilder.subAggregation(agg);
            }
            aggregationBuilder = nestAggregationBuilder;
        }
        if (aggregationBuilder != null) {
            if (nestedAggregationClauseContext.subAggregationClause().size() > 0) {
                this.parseSubAggregationClauseContext((AggregationBuilder)aggregationBuilder, nestedAggregationClauseContext.subAggregationClause());
            }
            return aggregationBuilder;
        }
        throw new ElasticSql2DslException("[syntax error] nested aggregation not support this query format of the sql");
    }

    private AggregationBuilder parseSubAggregationClauseContext(AggregationBuilder aggregationBuilder, List<ElasticsearchParser.SubAggregationClauseContext> subAggregationClauseContexts) {
        for (ElasticsearchParser.SubAggregationClauseContext subAggregationClauseContext : subAggregationClauseContexts) {
            if (subAggregationClauseContext.aggregationClause().aggregateItemClause() != null) {
                List<AggregationBuilder> aggregationItems = this.parseAggregateItemClauseContext(subAggregationClauseContext.aggregationClause().aggregateItemClause());
                for (AggregationBuilder aggItem : aggregationItems) {
                    aggregationBuilder.subAggregation(aggItem);
                }
                return aggregationBuilder;
            }
            if (subAggregationClauseContext.aggregationClause().nestedAggregationClause() == null) continue;
            AggregationBuilder nestedAggregationBuilder = this.parseNestedAggregationClauseContext(subAggregationClauseContext.aggregationClause().nestedAggregationClause());
            aggregationBuilder.subAggregation(nestedAggregationBuilder);
            for (int i = 1; i < subAggregationClauseContext.aggregationClause().nestedAggregationClause().aggregationClause().size(); ++i) {
                for (AggregationBuilder agg : this.parseAggregationClauseContext(subAggregationClauseContext.aggregationClause().nestedAggregationClause().aggregationClause(i))) {
                    aggregationBuilder.subAggregation(agg);
                }
            }
            return aggregationBuilder;
        }
        throw new ElasticSql2DslException("not support yet");
    }

    private static List<AggregationParser> buildAggregationChain() {
        return ImmutableList.of((Object)new TermsAggregationParser(), (Object)new TopHitsAggregationParser(), (Object)new CardinalityAggregationParser(), (Object)new AvgAggregationParser(), (Object)new MaxAggregationParser(), (Object)new SumAggregationParser(), (Object)new MinAggregationParser(), (Object)new DerivativeAggregationParser());
    }
}

