/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.aggs;

import com.google.common.collect.ImmutableList;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.GroupByParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.group.AvgGroupByParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.group.CountGroupByParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.group.MaxGroupByParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.group.MinGroupByParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.group.SumGroupByParser;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationBuilder;

public class GroupByQueryParser {
    public AggregationBuilder parse(String funcName, String field, Object ... params) {
        for (GroupByParser groupByParser : GroupByQueryParser.buildGroupByParserChain()) {
            if (!funcName.equalsIgnoreCase(groupByParser.funcName)) continue;
            return groupByParser.parse(field, params);
        }
        throw new ElasticSql2DslException("not support groupBy function named:" + funcName);
    }

    private static List<GroupByParser> buildGroupByParserChain() {
        return ImmutableList.of((Object)new CountGroupByParser(), (Object)new AvgGroupByParser(), (Object)new MaxGroupByParser(), (Object)new MinGroupByParser(), (Object)new SumGroupByParser());
    }
}

