/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.bucket;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.AggregateQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.AggregationParser;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class TermsAggregationParser
implements AggregationParser {
    private static final String AGG_TERMS_METHOD = "terms";

    @Override
    public void parseAggregateItemClauseContext(AggregateQuery aggregateQuery, ElasticsearchParser.AggregateItemClauseContext aggregateItemClauseContext) {
        if (StringUtils.equalsIgnoreCase((CharSequence)aggregateItemClauseContext.ID().getText(), (CharSequence)AGG_TERMS_METHOD)) {
            try {
                String field = aggregateItemClauseContext.collection().identity(0).getText();
                int size = 10;
                if (aggregateItemClauseContext.collection().identity().size() > 1) {
                    size = Integer.parseInt(aggregateItemClauseContext.collection().identity(1).getText());
                }
                aggregateQuery.setAggregationBuilder((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)(field + "_terms")).field(field)).size(size).minDocCount(1L).shardMinDocCount(1L).shardSize(size << 1).order(BucketOrder.count((boolean)false)));
            }
            catch (IllegalArgumentException e) {
                throw new ElasticSql2DslException(e);
            }
        }
    }
}

