/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlConditionOperator;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact.AbstractExactQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class BetweenAndQueryParser
extends AbstractExactQueryParser {
    public AtomicQuery parse(ElasticsearchParser.BetweenAndContext betweenAndContext) {
        if (betweenAndContext.rangeClause() != null) {
            ElasticsearchParser.RangeClauseContext rangeClauseContext = betweenAndContext.rangeClause();
            String field2 = rangeClauseContext.field.getText();
            RangeQueryBuilder queryBuilder = QueryBuilders.rangeQuery((String)field2);
            String leftValue = StringManager.removeStringSymbol(rangeClauseContext.left.getText());
            String rightValue = StringManager.removeStringSymbol(rangeClauseContext.right.getText());
            if (rangeClauseContext.LPAREN() != null) {
                queryBuilder.gt((Object)leftValue);
            } else {
                queryBuilder.gte((Object)leftValue);
            }
            if (rangeClauseContext.RPAREN() != null) {
                queryBuilder.lt((Object)rightValue);
            } else {
                queryBuilder.lte((Object)rightValue);
            }
            return new AtomicQuery((QueryBuilder)queryBuilder);
        }
        return this.parseCondition(betweenAndContext, SqlConditionOperator.BetweenAnd, new Object[]{betweenAndContext.left.getText(), betweenAndContext.right.getText()}, (field, operator, params) -> QueryBuilders.rangeQuery((String)field).gte((Object)StringManager.removeStringSymbol(params[0].toString())).lte((Object)StringManager.removeStringSymbol(params[1].toString())));
    }
}

