/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlConditionOperator;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact.AbstractExactQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact.BetweenAndQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact.InListQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.fulltext.ExistsQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.fulltext.FullTextQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.fulltext.LikeQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo.GeoQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.join.JoinQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.nested.NestedQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class BinaryQueryParser
extends AbstractExactQueryParser {
    private final GeoQueryParser geoQueryParser = new GeoQueryParser();
    private final JoinQueryParser joinQueryParser = new JoinQueryParser();
    private final LikeQueryParser likeQueryParser = new LikeQueryParser();
    private final InListQueryParser inListQueryParser = new InListQueryParser();
    private final NestedQueryParser nestedQueryParser = new NestedQueryParser();
    private final FullTextQueryParser fullTextQueryParser = new FullTextQueryParser();
    private final BetweenAndQueryParser betweenAndQueryParser = new BetweenAndQueryParser();
    private final ExistsQueryParser existsQueryParser = new ExistsQueryParser();

    private AtomicQuery parseBinaryQuery(ElasticsearchParser.BinaryContext binaryContext) {
        if (binaryContext.operator != null) {
            int operatorType = binaryContext.operator.getType();
            if (operatorType == 109 || operatorType == 117 || operatorType == 110 || operatorType == 112 || operatorType == 111 || operatorType == 113 || operatorType == 114 || operatorType == 115) {
                SqlConditionOperator operator;
                String targetVal = binaryContext.rightExpr.getText();
                switch (operatorType) {
                    case 117: {
                        operator = SqlConditionOperator.NotEqual;
                        break;
                    }
                    case 110: {
                        operator = SqlConditionOperator.ApproximatelyEqual;
                        break;
                    }
                    case 111: {
                        operator = SqlConditionOperator.ApproximatelyNotEqual;
                        break;
                    }
                    case 112: {
                        operator = SqlConditionOperator.MatchPhrase;
                        break;
                    }
                    case 113: {
                        operator = SqlConditionOperator.NotMatchPhrase;
                        break;
                    }
                    case 114: {
                        operator = SqlConditionOperator.MatchPhrasePrefix;
                        break;
                    }
                    case 115: {
                        operator = SqlConditionOperator.NotMatchPhrasePrefix;
                        break;
                    }
                    default: {
                        operator = SqlConditionOperator.Equality;
                    }
                }
                return this.parseCondition(binaryContext.leftExpr, operator, new Object[]{targetVal}, (fieldName, operator1, rightParams) -> {
                    switch (operator1) {
                        case NotEqual: {
                            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)StringManager.removeStringSymbol(rightParams[0].toString())));
                        }
                        case ApproximatelyEqual: {
                            return QueryBuilders.matchQuery((String)fieldName, (Object)StringManager.removeStringSymbol(rightParams[0].toString()));
                        }
                        case ApproximatelyNotEqual: {
                            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)StringManager.removeStringSymbol(rightParams[0].toString())));
                        }
                        case MatchPhrase: {
                            return QueryBuilders.matchPhraseQuery((String)fieldName, (Object)StringManager.removeStringSymbol(rightParams[0].toString()));
                        }
                        case NotMatchPhrase: {
                            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchPhraseQuery((String)fieldName, (Object)StringManager.removeStringSymbol(rightParams[0].toString())));
                        }
                        case MatchPhrasePrefix: {
                            return QueryBuilders.matchPhrasePrefixQuery((String)fieldName, (Object)StringManager.removeStringSymbol(rightParams[0].toString()));
                        }
                        case NotMatchPhrasePrefix: {
                            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)fieldName, (Object)StringManager.removeStringSymbol(rightParams[0].toString())));
                        }
                    }
                    return QueryBuilders.termQuery((String)fieldName, (String)StringManager.removeStringSymbol(rightParams[0].toString()));
                });
            }
            if (operatorType == 24 || operatorType == 25) {
                ElasticsearchParser.ExpressionContext leftExpr = binaryContext.leftExpr;
                ElasticsearchParser.ExpressionContext rightExpr = binaryContext.rightExpr;
                if (this.binaryContextMatch(leftExpr) && this.binaryContextMatch(rightExpr)) {
                    AtomicQuery leftQuery = this.parseExpressionContext(leftExpr);
                    AtomicQuery rightQuery = this.parseExpressionContext(rightExpr);
                    BoolQueryBuilder boolQueryBuilder = operatorType == 24 ? QueryBuilders.boolQuery().must(leftQuery.getQueryBuilder()).must(rightQuery.getQueryBuilder()) : QueryBuilders.boolQuery().should(leftQuery.getQueryBuilder()).should(rightQuery.getQueryBuilder());
                    AtomicQuery atomicQuery = new AtomicQuery((QueryBuilder)boolQueryBuilder);
                    this.mergeHighlighterSet(atomicQuery, leftQuery, rightQuery);
                    return atomicQuery;
                }
                throw new ElasticSql2DslException("expressions on  both sides of [and or && ||] must be binary context");
            }
            if (operatorType == 118 || operatorType == 119 || operatorType == 120 || operatorType == 121) {
                SqlConditionOperator operator;
                switch (operatorType) {
                    case 118: {
                        operator = SqlConditionOperator.GreaterThan;
                        break;
                    }
                    case 119: {
                        operator = SqlConditionOperator.GreaterThanOrEqual;
                        break;
                    }
                    case 120: {
                        operator = SqlConditionOperator.LessThan;
                        break;
                    }
                    default: {
                        operator = SqlConditionOperator.LessThanOrEqual;
                    }
                }
                String targetVal = binaryContext.rightExpr.getText();
                return this.parseCondition(binaryContext.leftExpr, operator, new Object[]{targetVal}, (fieldName, operator1, rightParams) -> {
                    RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)fieldName);
                    switch (operator1) {
                        case GreaterThan: {
                            return rangeQuery.gt((Object)StringManager.removeStringSymbol(rightParams[0].toString()));
                        }
                        case GreaterThanOrEqual: {
                            return rangeQuery.gte((Object)StringManager.removeStringSymbol(rightParams[0].toString()));
                        }
                        case LessThan: {
                            return rangeQuery.lt((Object)StringManager.removeStringSymbol(rightParams[0].toString()));
                        }
                    }
                    return rangeQuery.lte((Object)StringManager.removeStringSymbol(rightParams[0].toString()));
                });
            }
        } else {
            if (binaryContext.isClause() != null) {
                ElasticsearchParser.IsClauseContext isClauseContext = binaryContext.isClause();
                return this.existsQueryParser.parse(isClauseContext);
            }
            if (binaryContext.likeClause() != null) {
                ElasticsearchParser.LikeClauseContext likeClauseContext = binaryContext.likeClause();
                return this.likeQueryParser.parse(likeClauseContext);
            }
            if (binaryContext.notClause() != null) {
                return this.parseNotExpressionContext(binaryContext.notClause());
            }
        }
        throw new ElasticSql2DslException("[syntax error] not supported yet");
    }

    private void mergeHighlighterSet(AtomicQuery atomicQuery, AtomicQuery ... atomicQueries) {
        for (AtomicQuery atomicQueryItem : atomicQueries) {
            atomicQuery.getHighlighter().addAll(atomicQueryItem.getHighlighter());
        }
    }

    private AtomicQuery parseNotExpressionContext(ElasticsearchParser.NotClauseContext notClauseContext) {
        AtomicQuery query = this.parseExpressionContext(notClauseContext.expression());
        return new AtomicQuery((QueryBuilder)QueryBuilders.boolQuery().mustNot(query.getQueryBuilder()));
    }

    public AtomicQuery parseExpressionContext(ElasticsearchParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof ElasticsearchParser.BinaryContext) {
            ElasticsearchParser.BinaryContext leftBinary = (ElasticsearchParser.BinaryContext)expressionContext;
            return this.parseBinaryQuery(leftBinary);
        }
        if (expressionContext instanceof ElasticsearchParser.LrExprContext) {
            ElasticsearchParser.LrExprContext leftLrExpr = (ElasticsearchParser.LrExprContext)expressionContext;
            return this.parseExpressionContext(leftLrExpr.expression());
        }
        if (expressionContext instanceof ElasticsearchParser.GeoContext) {
            ElasticsearchParser.GeoContext geoContext = (ElasticsearchParser.GeoContext)expressionContext;
            return this.geoQueryParser.parse(geoContext);
        }
        if (expressionContext instanceof ElasticsearchParser.JoinContext) {
            return this.joinQueryParser.parse((ElasticsearchParser.JoinContext)expressionContext);
        }
        if (expressionContext instanceof ElasticsearchParser.InContext) {
            return this.inListQueryParser.parse((ElasticsearchParser.InContext)expressionContext);
        }
        if (expressionContext instanceof ElasticsearchParser.NestedContext) {
            return this.nestedQueryParser.parse((ElasticsearchParser.NestedContext)expressionContext);
        }
        if (expressionContext instanceof ElasticsearchParser.FullTextContext) {
            return this.fullTextQueryParser.parse((ElasticsearchParser.FullTextContext)expressionContext);
        }
        if (expressionContext instanceof ElasticsearchParser.BetweenAndContext) {
            return this.betweenAndQueryParser.parse((ElasticsearchParser.BetweenAndContext)expressionContext);
        }
        if (expressionContext instanceof ElasticsearchParser.NameExprContext) {
            ElasticsearchParser.NameExprContext nameExprContext = (ElasticsearchParser.NameExprContext)expressionContext;
            if (nameExprContext.nameClause() instanceof ElasticsearchParser.FunctionNameContext) {
                ElasticsearchParser.FunctionNameContext functionNameContext = (ElasticsearchParser.FunctionNameContext)nameExprContext.nameClause();
                String functionName = functionNameContext.functionName.getText();
                functionNameContext.collection().identity();
                throw new ElasticSql2DslException("not support yet");
            }
            throw new ElasticSql2DslException("not support yet");
        }
        throw new ElasticSql2DslException("not support yet");
    }

    private boolean binaryContextMatch(ElasticsearchParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof ElasticsearchParser.BinaryContext) {
            return true;
        }
        if (expressionContext instanceof ElasticsearchParser.LrExprContext) {
            return true;
        }
        if (expressionContext instanceof ElasticsearchParser.GeoContext) {
            return true;
        }
        if (expressionContext instanceof ElasticsearchParser.NestedContext) {
            return true;
        }
        if (expressionContext instanceof ElasticsearchParser.FullTextContext) {
            return true;
        }
        if (expressionContext instanceof ElasticsearchParser.NameExprContext) {
            return true;
        }
        return expressionContext instanceof ElasticsearchParser.JoinContext;
    }
}

