/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlConditionOperator;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact.AbstractExactQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class InListQueryParser
extends AbstractExactQueryParser {
    public AtomicQuery parse(ElasticsearchParser.InContext inContext) {
        SqlConditionOperator operator = inContext.inClause().NOT() == null ? SqlConditionOperator.In : SqlConditionOperator.NotIn;
        ArrayList<String> inList = new ArrayList<String>(0);
        for (ElasticsearchParser.InRightOperandContext rightCtx : inContext.inClause().right.inRightOperand()) {
            if (!(rightCtx instanceof ElasticsearchParser.ConstLiteralContext)) continue;
            ElasticsearchParser.ConstLiteralContext literalContext = (ElasticsearchParser.ConstLiteralContext)rightCtx;
            inList.add(literalContext.identity().getText());
        }
        return this.parseCondition(inContext.inClause(), operator, inList.toArray(new Object[0]), (fieldName, operator1, rightParams) -> {
            if (SqlConditionOperator.In == operator1) {
                return QueryBuilders.termsQuery((String)fieldName, (Collection)Arrays.stream(rightParams).map(param -> StringManager.removeStringSymbol(param.toString())).collect(Collectors.toList()));
            }
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, (Collection)Arrays.stream(rightParams).map(param -> StringManager.removeStringSymbol(param.toString())).collect(Collectors.toList())));
        });
    }
}

