/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.fulltext;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.ExpressionQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import java.util.HashSet;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class MultiMatchQueryParser
implements ExpressionQueryParser<ElasticsearchParser.MultiMatchClauseContext> {
    @Override
    public AtomicQuery parse(ElasticsearchParser.MultiMatchClauseContext expression) {
        String[] fields = new String[expression.nameClause().size()];
        HashSet<String> highlighters = new HashSet<String>(0);
        for (int i = 0; i < expression.nameClause().size(); ++i) {
            if (!(expression.nameClause(i) instanceof ElasticsearchParser.FieldNameContext)) continue;
            ElasticsearchParser.FieldNameContext fieldNameContext = (ElasticsearchParser.FieldNameContext)expression.nameClause(i);
            if (fieldNameContext.highlighter != null) {
                highlighters.add(fieldNameContext.field.getText());
            }
            fields[i] = fieldNameContext.field.getText();
        }
        String value = StringManager.removeStringSymbol(expression.value.getText());
        AtomicQuery atomicQuery = new AtomicQuery((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])fields));
        atomicQuery.getHighlighter().addAll(highlighters);
        return atomicQuery;
    }

    @Override
    public boolean isMatchExpressionInvocation(Class clazz) {
        return ElasticsearchParser.MultiMatchClauseContext.class == clazz;
    }
}

