/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.fulltext.like;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlConditionOperator;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.exact.AbstractExactQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.fulltext.like.LikeQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;

public class WildcardLikeQueryParser
extends AbstractExactQueryParser
implements LikeQueryParser {
    @Override
    public AtomicQuery parse(ElasticsearchParser.LikeClauseContext expression) {
        SqlConditionOperator operator = expression.not == null ? SqlConditionOperator.Like : SqlConditionOperator.NotLike;
        return this.parseCondition(expression, operator, null, (fieldName, operator1, rightParams) -> {
            String pattern = StringManager.removeStringSymbol(expression.pattern.getText());
            WildcardQueryBuilder wildcardQuery = QueryBuilders.wildcardQuery((String)fieldName, (String)pattern);
            switch (operator1) {
                case Like: {
                    return wildcardQuery;
                }
            }
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)wildcardQuery);
        });
    }

    @Override
    public boolean isMatchExpressionInvocation(Class clazz) {
        return ElasticsearchParser.LikeClauseContext.class == clazz;
    }
}

