/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.ExpressionQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.GeoUtils;
import io.github.iamazy.elasticsearch.dsl.utils.StringManager;
import java.io.IOException;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeoJsonShapeQueryParser
implements ExpressionQueryParser<ElasticsearchParser.GeoJsonShapeClauseContext> {
    @Override
    public AtomicQuery parse(ElasticsearchParser.GeoJsonShapeClauseContext expression) {
        try {
            GeoShapeQueryBuilder queryBuilder = QueryBuilders.geoShapeQuery((String)expression.field.getText(), (Geometry)this.parseGeometry(StringManager.removeStringSymbol(expression.geojson.getText()))).relation(GeoUtils.parseGeoRelation(expression.relation.getType()));
            return new AtomicQuery((QueryBuilder)queryBuilder);
        }
        catch (Exception e) {
            throw new ElasticSql2DslException("geo shape parse error: " + e.getMessage());
        }
    }

    @Override
    public boolean isMatchExpressionInvocation(Class clazz) {
        return ElasticsearchParser.GeoJsonShapeClauseContext.class == clazz;
    }

    private Geometry parseGeometry(String geometry) throws IOException {
        XContentParser xContentParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, geometry);
        xContentParser.nextToken();
        return ShapeParser.parse((XContentParser)xContentParser).buildGeometry();
    }
}

