/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.ExpressionQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.GeoUtils;
import java.util.ArrayList;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeoPolygonQueryParser
implements ExpressionQueryParser<ElasticsearchParser.GeoPolygonClauseContext> {
    @Override
    public AtomicQuery parse(ElasticsearchParser.GeoPolygonClauseContext expression) {
        String field = expression.ID().getText();
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(expression.point().size());
        for (ElasticsearchParser.PointContext pointContext : expression.point()) {
            points.add(GeoUtils.parseGeoPoint(pointContext));
        }
        return new AtomicQuery((QueryBuilder)QueryBuilders.geoPolygonQuery((String)field, points));
    }

    @Override
    public boolean isMatchExpressionInvocation(Class clazz) {
        return ElasticsearchParser.GeoPolygonClauseContext.class == clazz;
    }
}

