/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.ExpressionQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo.GeoBoundingBoxQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo.GeoDistanceQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo.GeoJsonShapeQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo.GeoPolygonQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo.GeoShapeQueryParser;

public class GeoQueryParser
implements ExpressionQueryParser<ElasticsearchParser.GeoContext> {
    private GeoDistanceQueryParser geoDistanceQueryParser = new GeoDistanceQueryParser();
    private GeoPolygonQueryParser geoPolygonQueryParser;
    private GeoBoundingBoxQueryParser geoBoundingBoxQueryParser = new GeoBoundingBoxQueryParser();
    private GeoShapeQueryParser geoShapeQueryParser;
    private GeoJsonShapeQueryParser geoJsonShapeQueryParser;

    public GeoQueryParser() {
        this.geoPolygonQueryParser = new GeoPolygonQueryParser();
        this.geoShapeQueryParser = new GeoShapeQueryParser();
        this.geoJsonShapeQueryParser = new GeoJsonShapeQueryParser();
    }

    @Override
    public AtomicQuery parse(ElasticsearchParser.GeoContext expression) {
        if (expression.geoClause().geoDistanceClause() != null) {
            return this.geoDistanceQueryParser.parse(expression.geoClause().geoDistanceClause());
        }
        if (expression.geoClause().geoBoundingBoxClause() != null) {
            return this.geoBoundingBoxQueryParser.parse(expression.geoClause().geoBoundingBoxClause());
        }
        if (expression.geoClause().geoPolygonClause() != null) {
            return this.geoPolygonQueryParser.parse(expression.geoClause().geoPolygonClause());
        }
        if (expression.geoClause().geoShapeClause() != null) {
            return this.geoShapeQueryParser.parse(expression.geoClause().geoShapeClause());
        }
        if (expression.geoClause().geoJsonShapeClause() != null) {
            return this.geoJsonShapeQueryParser.parse(expression.geoClause().geoJsonShapeClause());
        }
        throw new ElasticSql2DslException("geo query only support GeoDistanceQuery yet");
    }

    @Override
    public boolean isMatchExpressionInvocation(Class clazz) {
        return ElasticsearchParser.GeoContext.class == clazz || ElasticsearchParser.GeoDistanceClauseContext.class == clazz || ElasticsearchParser.GeoBoundingBoxClauseContext.class == clazz || ElasticsearchParser.GeoPolygonClauseContext.class == clazz || ElasticsearchParser.GeoShapeClauseContext.class == clazz;
    }
}

