/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.sql.parser.query.geo;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.AtomicQuery;
import io.github.iamazy.elasticsearch.dsl.sql.parser.ExpressionQueryParser;
import io.github.iamazy.elasticsearch.dsl.utils.GeoUtils;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class GeoShapeQueryParser
implements ExpressionQueryParser<ElasticsearchParser.GeoShapeClauseContext> {
    @Override
    public AtomicQuery parse(ElasticsearchParser.GeoShapeClauseContext expression) {
        try {
            GeoShapeQueryBuilder queryBuilder = QueryBuilders.geoShapeQuery((String)expression.field.getText(), (Geometry)this.parseShapeBuilder(expression.shape.getType(), expression)).relation(GeoUtils.parseGeoRelation(expression.relation.getType()));
            return new AtomicQuery((QueryBuilder)queryBuilder);
        }
        catch (Exception e) {
            throw new ElasticSql2DslException("geo shape parse error: " + e.getMessage());
        }
    }

    @Override
    public boolean isMatchExpressionInvocation(Class clazz) {
        return ElasticsearchParser.GeoShapeClauseContext.class == clazz;
    }

    private Geometry parseShapeBuilder(int shape, ElasticsearchParser.GeoShapeClauseContext geoShapeClauseContext) {
        switch (shape) {
            case 68: {
                return this.parsePointContext(geoShapeClauseContext.point());
            }
            case 75: {
                return this.parseRectangleContext(geoShapeClauseContext.points());
            }
            case 69: {
                return this.parseLineContext(geoShapeClauseContext.points());
            }
            case 71: {
                return new MultiPoint(this.parsePointsContext(geoShapeClauseContext.points()));
            }
            case 72: {
                ElasticsearchParser.PolygonContext polygonContext = geoShapeClauseContext.polygon();
                ArrayList<Line> lines = new ArrayList<Line>(0);
                for (ElasticsearchParser.PointsContext pointsContext : polygonContext.points()) {
                    lines.add(new Line(this.traversePointsX(pointsContext), this.traversePointsY(pointsContext)));
                }
                return new MultiLine(lines);
            }
            case 70: {
                return this.parsePolygonContext(geoShapeClauseContext.polygon());
            }
        }
        ArrayList<Polygon> multiPolygon = new ArrayList<Polygon>(0);
        ElasticsearchParser.MultiPolygonContext multiPolygonContext = geoShapeClauseContext.multiPolygon();
        for (ElasticsearchParser.PolygonContext polygonContext : multiPolygonContext.polygon()) {
            multiPolygon.add(this.parsePolygonContext(polygonContext));
        }
        return new MultiPolygon(multiPolygon);
    }

    private Point parsePointContext(ElasticsearchParser.PointContext pointContext) {
        return new Point(Double.parseDouble(pointContext.lon.getText()), Double.parseDouble(pointContext.lat.getText()));
    }

    private Rectangle parseRectangleContext(ElasticsearchParser.PointsContext pointsContext) {
        double minX = Double.parseDouble(pointsContext.point((int)0).lon.getText());
        double maxX = Double.parseDouble(pointsContext.point((int)1).lon.getText());
        double minY = Double.parseDouble(pointsContext.point((int)0).lat.getText());
        double maxY = Double.parseDouble(pointsContext.point((int)1).lat.getText());
        return new Rectangle(minX, maxX, maxY, minY);
    }

    private List<Point> parsePointsContext(ElasticsearchParser.PointsContext pointsContext) {
        ArrayList<Point> points = new ArrayList<Point>(0);
        for (ElasticsearchParser.PointContext pointContext : pointsContext.point()) {
            points.add(this.parsePointContext(pointContext));
        }
        return points;
    }

    private Line parseLineContext(ElasticsearchParser.PointsContext pointsContext) {
        return new Line(this.traversePointsX(pointsContext), this.traversePointsY(pointsContext));
    }

    private LinearRing parseLinearRingContext(ElasticsearchParser.PointsContext pointsContext) {
        return new LinearRing(this.traversePointsX(pointsContext), this.traversePointsY(pointsContext));
    }

    private double[] traversePointsX(ElasticsearchParser.PointsContext pointsContext) {
        double[] lats = new double[pointsContext.point().size()];
        for (int i = 0; i < pointsContext.point().size(); ++i) {
            lats[i] = Double.parseDouble(pointsContext.point((int)i).lon.getText());
        }
        return lats;
    }

    private double[] traversePointsY(ElasticsearchParser.PointsContext pointsContext) {
        double[] lons = new double[pointsContext.point().size()];
        for (int i = 0; i < pointsContext.point().size(); ++i) {
            lons[i] = Double.parseDouble(pointsContext.point((int)i).lat.getText());
        }
        return lons;
    }

    private Polygon parsePolygonContext(ElasticsearchParser.PolygonContext polygonContext) {
        LinearRing linearRing = this.parseLinearRingContext(polygonContext.points(0));
        ArrayList<LinearRing> linearRings = new ArrayList<LinearRing>(0);
        for (int i = 1; i < polygonContext.points().size(); ++i) {
            linearRings.add(this.parseLinearRingContext(polygonContext.points(i)));
        }
        return new Polygon(linearRing, linearRings);
    }
}

