/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FlatMapUtils {
    public static Map<String, Object> flat(Map<String, ?> map, String parentKey) {
        String parent = parentKey == null ? "" : parentKey;
        HashMap<String, Object> dataInfo = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) {
                if (StringUtils.isNotBlank((CharSequence)parent)) {
                    dataInfo.put(parent + "." + entry.getKey(), entry.getValue() != null ? entry.getValue() : "");
                    continue;
                }
                dataInfo.put(entry.getKey(), entry.getValue() != null ? entry.getValue() : "");
                continue;
            }
            Map childMap = (Map)entry.getValue();
            parent = StringUtils.isNotBlank((CharSequence)parent) ? parent + "." + entry.getKey() : entry.getKey();
            dataInfo.putAll(FlatMapUtils.flat(childMap, parent));
            if (parent.contains(".")) {
                parent = parent.substring(0, parent.lastIndexOf("."));
                continue;
            }
            parent = "";
        }
        return dataInfo;
    }

    public static void flatPut(String key, Object value, Map<String, Object> map) {
        if (key.contains(".")) {
            String firstItem = key.substring(0, key.indexOf("."));
            String restItems = key.substring(key.indexOf(".") + 1);
            if (!map.containsKey(firstItem)) {
                map.put(firstItem, new HashMap(0));
            }
            FlatMapUtils.flatPut(restItems, value, (Map)map.get(firstItem));
        } else {
            map.put(key, value);
        }
    }

    public static Object flatGet(String key, Map<String, Object> map) {
        if (key.contains(".")) {
            String firstItem = key.substring(0, key.indexOf("."));
            String restItems = key.substring(key.indexOf(".") + 1);
            if (map.containsKey(firstItem) && map.get(firstItem) instanceof Map) {
                return FlatMapUtils.flatGet(restItems, (Map)map.get(firstItem));
            }
            return null;
        }
        return map.get(key);
    }
}

