/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.util.UUID;
import net.datafaker.Faker;

public class Aws {
    private final Faker faker;

    protected Aws(Faker faker) {
        this.faker = faker;
    }

    public String region() {
        return this.faker.fakeValuesService().resolve("aws.regions", this, this.faker);
    }

    public String accountId() {
        return this.faker.numerify("0#########");
    }

    public String acmARN() {
        return "arn:aws:acm:" + this.region() + ":" + this.accountId() + ":certificate/" + UUID.randomUUID();
    }

    public String albARN() {
        return "arn:aws:elasticloadbalancing:" + this.region() + ":" + this.accountId() + ":loadbalancer/app/" + this.appName() + "/" + this.randHex();
    }

    public String albTargetGroupARN() {
        return "arn:aws:elasticloadbalancing:" + this.region() + ":" + this.accountId() + ":targetgroup/" + this.appName() + "/" + this.randHex();
    }

    public String route53ZoneId() {
        return this.faker.regexify("[A-Z]{21}");
    }

    public String securityGroupId() {
        return "sg-" + this.randHex();
    }

    public String subnetId() {
        return "subnet-" + this.randHex();
    }

    public String vpcId() {
        return "vpc-" + this.randHex();
    }

    private String appName() {
        return this.faker.app().name().toLowerCase().replaceAll("\\W+", "");
    }

    private String randHex() {
        return this.faker.regexify("[a-f0-9]{16}");
    }
}

