/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import net.datafaker.Faker;

public class Barcode {
    private final Faker faker;

    public Barcode(Faker faker) {
        this.faker = faker;
    }

    public long ean13() {
        return this.ean(13);
    }

    public long ean8() {
        return this.ean(8);
    }

    public long gtin14() {
        return this.ean(14);
    }

    public long gtin12() {
        return this.ean(12);
    }

    public long gtin13() {
        return this.ean13();
    }

    public long gtin8() {
        return this.ean8();
    }

    private static int roundToHighestMultiplyOfTen(int number) {
        if (number % 10 == 0) {
            return number;
        }
        int ones = number % 10;
        int add = 10 - ones;
        return number + add;
    }

    private long ean(int length) {
        long first = 0L;
        switch (length) {
            case 13: {
                first = this.faker.number().randomNumber(12, true);
                break;
            }
            case 8: {
                first = this.faker.number().randomNumber(7, true);
                break;
            }
            case 14: {
                first = this.faker.number().randomNumber(13, true);
                break;
            }
            case 12: {
                first = this.faker.number().randomNumber(11, true);
            }
        }
        char[] array = String.valueOf(first).toCharArray();
        int odd = 0;
        int even = 0;
        for (int i = 0; i < array.length; ++i) {
            int digit = Integer.parseInt(String.valueOf(array[i]));
            if ((i + 1) % 2 == 0) {
                even += digit;
                continue;
            }
            odd += digit;
        }
        int var = 0;
        if (length == 13) {
            var = even * 3 + odd;
        }
        if (length == 8 || length == 14 || length == 12) {
            var = odd * 3 + even;
        }
        int rounded = Barcode.roundToHighestMultiplyOfTen(var);
        int checkDigit = rounded - var;
        return Long.parseLong(first + String.valueOf(checkDigit));
    }

    public String type() {
        return this.faker.resolve("barcode.types");
    }
}

