/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.TreeSet;
import net.datafaker.Faker;

public class Commerce {
    private final Faker faker;
    private final DecimalFormatSymbols decimalFormatSymbols;

    protected Commerce(Faker faker) {
        this.faker = faker;
        this.decimalFormatSymbols = new DecimalFormatSymbols(faker.getLocale());
    }

    public String department() {
        int numberOfDepartments = Math.max(this.faker.random().nextInt(4), 1);
        TreeSet<String> departments = new TreeSet<String>();
        while (departments.size() < numberOfDepartments) {
            departments.add(this.faker.fakeValuesService().resolve("commerce.department", this, this.faker));
        }
        if (departments.size() > 1) {
            String lastDepartment = (String)departments.last();
            return String.join((CharSequence)", ", departments.headSet(lastDepartment)) + " & " + lastDepartment;
        }
        return (String)departments.first();
    }

    public String productName() {
        return String.join((CharSequence)" ", this.faker.fakeValuesService().resolve("commerce.product_name.adjective", this, this.faker), this.faker.fakeValuesService().resolve("commerce.product_name.material", this, this.faker), this.faker.fakeValuesService().resolve("commerce.product_name.product", this, this.faker));
    }

    public String material() {
        return this.faker.fakeValuesService().resolve("commerce.product_name.material", this, this.faker);
    }

    public String brand() {
        return this.faker.fakeValuesService().resolve("commerce.brand", this, this.faker);
    }

    public String vendor() {
        return this.faker.fakeValuesService().resolve("commerce.vendor", this, this.faker);
    }

    public String price() {
        return this.price(0.0, 100.0);
    }

    public String price(double min, double max) {
        double price = min + this.faker.random().nextDouble() * (max - min);
        return new DecimalFormat("#0.00", this.decimalFormatSymbols).format(price);
    }

    public String promotionCode() {
        return this.promotionCode(6);
    }

    public String promotionCode(int digits) {
        return String.join((CharSequence)this.faker.resolve("commerce.promotion_code.adjective"), this.faker.resolve("commerce.promotion_code.noun"), this.faker.number().digits(digits));
    }
}

