/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.datafaker.Faker;
import net.datafaker.service.FakerIDN;

public class Company {
    private static final Pattern UNWANTED_CHARACTERS = Pattern.compile("[.,' ]");
    private final Faker faker;

    protected Company(Faker faker) {
        this.faker = faker;
    }

    public String name() {
        return this.faker.fakeValuesService().resolve("company.name", this, this.faker);
    }

    public String suffix() {
        return this.faker.fakeValuesService().resolve("company.suffix", this, this.faker);
    }

    public String industry() {
        return this.faker.fakeValuesService().resolve("company.industry", this, this.faker);
    }

    public String profession() {
        return this.faker.fakeValuesService().resolve("company.profession", this, this.faker);
    }

    public String buzzword() {
        List buzzwordLists = (List)this.faker.fakeValuesService().fetchObject("company.buzzwords");
        ArrayList buzzwords = new ArrayList();
        for (List buzzwordList : buzzwordLists) {
            buzzwords.addAll(buzzwordList);
        }
        return (String)buzzwords.get(this.faker.random().nextInt(buzzwords.size()));
    }

    public String catchPhrase() {
        List catchPhraseLists = (List)this.faker.fakeValuesService().fetchObject("company.buzzwords");
        return this.joinSampleOfEachList(catchPhraseLists);
    }

    public String bs() {
        List buzzwordLists = (List)this.faker.fakeValuesService().fetchObject("company.bs");
        return this.joinSampleOfEachList(buzzwordLists);
    }

    public String logo() {
        int number = this.faker.random().nextInt(13) + 1;
        return "https://pigment.github.io/fake-logos/logos/medium/color/" + number + ".png";
    }

    public String url() {
        return String.join((CharSequence)".", "www", FakerIDN.toASCII(this.domainName()), this.domainSuffix());
    }

    private String domainName() {
        return UNWANTED_CHARACTERS.matcher(this.name().toLowerCase(this.faker.getLocale())).replaceAll("");
    }

    private String domainSuffix() {
        return this.faker.fakeValuesService().resolve("internet.domain_suffix", this, this.faker);
    }

    private String joinSampleOfEachList(List<List<String>> listOfLists) {
        ArrayList<String> words = new ArrayList<String>();
        for (List<String> list : listOfLists) {
            words.add(list.get(this.faker.random().nextInt(list.size())));
        }
        return String.join((CharSequence)" ", words);
    }
}

