/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.datafaker.Faker;

public class DateAndTime {
    private static final int DEFAULT_MIN_AGE = 18;
    private static final int DEFAULT_MAX_AGE = 65;
    private final Faker faker;

    protected DateAndTime(Faker faker) {
        this.faker = faker;
    }

    public Timestamp future(int atMost, TimeUnit unit) {
        Timestamp aBitLaterThanNow = new Timestamp(System.currentTimeMillis() + 1000L);
        return this.future(atMost, unit, aBitLaterThanNow);
    }

    public String future(int atMost, TimeUnit unit, String pattern) {
        return this.toString(this.future(atMost, unit), pattern);
    }

    public Timestamp future(int atMost, int minimum, TimeUnit unit) {
        Timestamp minimumDate = new Timestamp(System.currentTimeMillis() + unit.toMillis(minimum));
        return this.future(atMost - minimum, unit, minimumDate);
    }

    public String future(int atMost, int minimum, TimeUnit unit, String pattern) {
        return this.toString(this.future(atMost, minimum, unit), pattern);
    }

    public Timestamp future(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Timestamp(futureMillis += 1L + this.faker.random().nextLong(upperBound - 1L));
    }

    public String future(int atMost, TimeUnit unit, Date referenceDate, String pattern) {
        return this.toString(this.future(atMost, unit, referenceDate), pattern);
    }

    public Timestamp past(int atMost, TimeUnit unit) {
        Timestamp aBitEarlierThanNow = new Timestamp(System.currentTimeMillis() - 1000L);
        return this.past(atMost, unit, aBitEarlierThanNow);
    }

    public String past(int atMost, TimeUnit unit, String pattern) {
        return this.toString(this.past(atMost, unit), pattern);
    }

    public Timestamp past(int atMost, int minimum, TimeUnit unit) {
        Timestamp minimumDate = new Timestamp(System.currentTimeMillis() - unit.toMillis(minimum));
        return this.past(atMost - minimum, unit, minimumDate);
    }

    public String past(int atMost, int minimum, TimeUnit unit, String pattern) {
        return this.toString(this.past(atMost, minimum, unit), pattern);
    }

    public Timestamp past(int atMost, TimeUnit unit, Date referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return new Timestamp(futureMillis -= 1L + this.faker.random().nextLong(upperBound - 1L));
    }

    public String past(int atMost, TimeUnit unit, Date referenceDate, String pattern) {
        return this.toString(this.past(atMost, unit, referenceDate), pattern);
    }

    public Timestamp between(Timestamp from, Timestamp to) throws IllegalArgumentException {
        if (to.before(from)) {
            throw new IllegalArgumentException("Invalid date range, the upper bound date is before the lower bound.");
        }
        if (from.equals(to)) {
            return from;
        }
        long offsetMillis = this.faker.random().nextLong(to.getTime() - from.getTime());
        return new Timestamp(from.getTime() + offsetMillis);
    }

    public String between(Timestamp from, Timestamp to, String pattern) throws IllegalArgumentException {
        return this.toString(this.between(from, to), pattern);
    }

    public Timestamp birthday() {
        return this.birthday(18, 65);
    }

    public String birthday(String pattern) {
        return this.toString(this.birthday(18, 65), pattern);
    }

    public Timestamp birthday(int minAge, int maxAge) {
        int currentYear = Calendar.getInstance().get(1);
        int currentMonth = Calendar.getInstance().get(2);
        int currentDay = Calendar.getInstance().get(5);
        GregorianCalendar from = new GregorianCalendar(currentYear - maxAge, currentMonth, currentDay);
        GregorianCalendar to = new GregorianCalendar(currentYear - minAge, currentMonth, currentDay);
        return this.between(new Timestamp(from.getTime().getTime()), new Timestamp(to.getTime().getTime()));
    }

    public String birthday(int minAge, int maxAge, String pattern) {
        return this.toString(this.birthday(minAge, maxAge), pattern);
    }

    public Duration duration(long max, ChronoUnit unit) {
        return this.duration(0L, max, unit);
    }

    public Duration duration(long min, long max, ChronoUnit unit) {
        return this.generateDuration(this.faker.random().nextLong(min, max), unit);
    }

    public Duration duration(long max, String unit) {
        return this.duration(0L, max, DateAndTime.str2durationUnit(unit));
    }

    public Duration duration(long min, long max, String unit) {
        return this.generateDuration(this.faker.random().nextLong(min, max), DateAndTime.str2durationUnit(unit));
    }

    public Period period(Period min, Period max) {
        if (max.minus(min).isNegative()) {
            throw new IllegalArgumentException("Max period(" + max + ") should be not less than min (" + min + ")");
        }
        return Period.of(this.faker.random().nextInt(min.getYears(), max.getYears() + 1), this.faker.random().nextInt(min.getMonths(), max.getMonths() + 1), this.faker.random().nextInt(min.getDays(), max.getDays() + 1));
    }

    static ChronoUnit str2durationUnit(String unit) {
        if (unit == null || unit.trim().isEmpty()) {
            throw new IllegalArgumentException("Illegal duration unit '" + unit + "'");
        }
        switch (unit.toUpperCase(Locale.ROOT)) {
            case "NANO": 
            case "NANOS": {
                return ChronoUnit.NANOS;
            }
            case "MICRO": 
            case "MICROS": {
                return ChronoUnit.MICROS;
            }
            case "MILLI": 
            case "MILLIS": {
                return ChronoUnit.MILLIS;
            }
            case "SECOND": 
            case "SECONDS": {
                return ChronoUnit.SECONDS;
            }
            case "MINUTE": 
            case "MINUTES": {
                return ChronoUnit.MINUTES;
            }
            case "HOUR": 
            case "HOURS": {
                return ChronoUnit.HOURS;
            }
            case "DAY": 
            case "DAYS": {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Illegal duration unit '" + unit + "'");
    }

    private Duration generateDuration(long value, ChronoUnit unit) {
        return Duration.of(value, unit);
    }

    private String toString(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }
}

