/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import net.datafaker.Faker;
import net.datafaker.service.RandomService;

public class Domain {
    private final Faker faker;

    protected Domain(Faker faker) {
        this.faker = faker;
    }

    public String firstLevelDomain(String name) {
        String top = this.faker.fakeValuesService().resolve("domain.top", this, this.faker);
        return String.join((CharSequence)"", name, ".", top);
    }

    public String secondLevelDomain(String name) {
        String top = this.faker.fakeValuesService().resolve("domain.top", this, this.faker);
        String suffix = this.faker.fakeValuesService().resolve("domain.country", this, this.faker);
        return String.join((CharSequence)"", name, ".", top, ".", suffix);
    }

    public String fullDomain(String name) {
        String prefix = this.faker.fakeValuesService().resolve("domain.prefix", this, this.faker);
        String top = this.faker.fakeValuesService().resolve("domain.top", this, this.faker);
        String suffix = this.faker.fakeValuesService().resolve("domain.country", this, this.faker);
        return String.join((CharSequence)"", prefix, ".", name, ".", top, ".", suffix);
    }

    public String validDomain(String name) {
        RandomService random = this.faker.random();
        boolean hasPrefix = random.nextInt(3) == 1;
        boolean hasSuffix = random.nextInt(2) == 1;
        String top = this.faker.fakeValuesService().resolve("domain.top", this, this.faker);
        String result = String.join((CharSequence)"", name, ".", top);
        if (hasPrefix) {
            String prefix = this.faker.fakeValuesService().resolve("domain.prefix", this, this.faker);
            result = String.join((CharSequence)"", prefix, ".", result);
        }
        if (hasSuffix) {
            String suffix = this.faker.fakeValuesService().resolve("domain.country", this, this.faker);
            result = String.join((CharSequence)"", result, ".", suffix);
        }
        return result;
    }
}

