/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import net.datafaker.Faker;

public class Dune {
    private final Faker faker;

    protected Dune(Faker faker) {
        this.faker = faker;
    }

    public String character() {
        return this.faker.fakeValuesService().resolve("dune.characters", this, this.faker);
    }

    public String title() {
        return this.faker.fakeValuesService().resolve("dune.titles", this, this.faker);
    }

    public String planet() {
        return this.faker.fakeValuesService().resolve("dune.planets", this, this.faker);
    }

    public String quote() {
        return this.quote(this.faker.options().option(Quote.class));
    }

    public String quote(Quote quote) {
        return this.faker.fakeValuesService().resolve("dune.quotes." + quote.yamlKey, this, this.faker);
    }

    public String saying() {
        return this.saying(this.faker.options().option(Saying.class));
    }

    public String saying(Saying saying) {
        return this.faker.fakeValuesService().resolve("dune.sayings." + saying.yamlKey, this, this.faker);
    }

    public static enum Saying {
        BENE_GESSERIT("bene_gesserit"),
        FREMEN("fremen"),
        MENTAT("mentat"),
        MUADDIB("muaddib"),
        ORANGE_CATHOLIC_BIBLE("orange_catholic_bible");

        private final String yamlKey;

        private Saying(String yamlKey) {
            this.yamlKey = yamlKey;
        }
    }

    public static enum Quote {
        GUILD_NAIVGATOR("guild_navigator"),
        GUILD_NAVIGATOR("guild_navigator"),
        EMPEROR("emperor"),
        PAUL("paul"),
        THUFIR("thufir"),
        JESSICA("jessica"),
        IRULAN("irulan"),
        MOHIAM("mohiam"),
        GURNEY("gurney"),
        LETO("leto"),
        STILGAR("stilgar"),
        LIET_KYNES("liet_kynes"),
        PARDOT_KYNES("pardot_kynes"),
        BARON_HARKONNEN("baron_harkonnen"),
        PITER("piter"),
        ALIA("alia"),
        MAPES("mapes"),
        DUNCAN("duncan"),
        YUEH("yueh");

        private final String yamlKey;

        private Quote(String yamlKey) {
            this.yamlKey = yamlKey;
        }
    }
}

