/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.datafaker.Faker;
import net.datafaker.service.RandomService;

public class FakeCollection<T> {
    private final RandomService randomService;
    private final List<Supplier<T>> suppliers;
    private final double nullRate;
    private final int minLength;
    private final int maxLength;

    private FakeCollection(List<Supplier<T>> suppliers, int minLength, int maxLength, RandomService randomService, double nullRate) {
        this.suppliers = suppliers;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.randomService = randomService;
        this.nullRate = nullRate;
    }

    public T singleton() {
        if (this.nullRate == 0.0 || this.randomService.nextDouble() >= this.nullRate) {
            return this.suppliers.get(this.randomService.nextInt(this.suppliers.size())).get();
        }
        return null;
    }

    public List<T> get() {
        ArrayList<T> result = new ArrayList<T>();
        int size = this.randomService.nextInt(this.minLength, this.maxLength);
        while (result.size() < size) {
            result.add(this.singleton());
        }
        return result;
    }

    public static class Builder<T> {
        private final List<Supplier<T>> suppliers = new ArrayList<Supplier<T>>();
        private int minLength = -1;
        private int maxLength = 10;
        private double nullRate = 0.0;
        private Faker faker;

        public Builder<T> faker(Faker faker) {
            this.faker = faker;
            return this;
        }

        public Builder<T> minLen(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder<T> maxLen(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder<T> nullRate(double nullRate) {
            if (nullRate < 0.0 || nullRate > 1.0) {
                throw new IllegalArgumentException("Null rate should be between 0 and 1");
            }
            this.nullRate = nullRate;
            return this;
        }

        @SafeVarargs
        public final Builder<T> suppliers(Supplier<T> ... suppliers) {
            Objects.requireNonNull(suppliers);
            this.suppliers.addAll(Arrays.asList(suppliers));
            return this;
        }

        public FakeCollection<T> build() {
            if (this.minLength > this.maxLength || this.maxLength < 0) {
                throw new IllegalArgumentException("Max length must be not less than min length and not negative");
            }
            this.minLength = this.minLength < 0 ? this.maxLength : this.minLength;
            RandomService randomService = this.faker == null ? new RandomService() : this.faker.random();
            return new FakeCollection(this.suppliers, this.minLength, this.maxLength, randomService, this.nullRate);
        }
    }
}

