/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.datafaker.Address;
import net.datafaker.Ancient;
import net.datafaker.Animal;
import net.datafaker.App;
import net.datafaker.Appliance;
import net.datafaker.AquaTeenHungerForce;
import net.datafaker.Artist;
import net.datafaker.Australia;
import net.datafaker.Avatar;
import net.datafaker.Aviation;
import net.datafaker.Aws;
import net.datafaker.Babylon5;
import net.datafaker.BackToTheFuture;
import net.datafaker.Barcode;
import net.datafaker.Basketball;
import net.datafaker.Battlefield1;
import net.datafaker.Beer;
import net.datafaker.BloodType;
import net.datafaker.BojackHorseman;
import net.datafaker.Book;
import net.datafaker.Bool;
import net.datafaker.BossaNova;
import net.datafaker.BreakingBad;
import net.datafaker.BrooklynNineNine;
import net.datafaker.Buffy;
import net.datafaker.Business;
import net.datafaker.CNPJ;
import net.datafaker.CPF;
import net.datafaker.Camera;
import net.datafaker.Cat;
import net.datafaker.ChuckNorris;
import net.datafaker.Code;
import net.datafaker.Coin;
import net.datafaker.Color;
import net.datafaker.Commerce;
import net.datafaker.Company;
import net.datafaker.Country;
import net.datafaker.CryptoCoin;
import net.datafaker.Currency;
import net.datafaker.DateAndTime;
import net.datafaker.Demographic;
import net.datafaker.Dessert;
import net.datafaker.Device;
import net.datafaker.Disease;
import net.datafaker.Dog;
import net.datafaker.Domain;
import net.datafaker.DragonBall;
import net.datafaker.Dune;
import net.datafaker.Educator;
import net.datafaker.EldenRing;
import net.datafaker.ElderScrolls;
import net.datafaker.ElectricalComponents;
import net.datafaker.EnglandFootBall;
import net.datafaker.Esports;
import net.datafaker.FakeCollection;
import net.datafaker.FakeDuration;
import net.datafaker.File;
import net.datafaker.Finance;
import net.datafaker.Food;
import net.datafaker.Formula1;
import net.datafaker.Friends;
import net.datafaker.FunnyName;
import net.datafaker.GameOfThrones;
import net.datafaker.Gender;
import net.datafaker.GratefulDead;
import net.datafaker.Hacker;
import net.datafaker.HarryPotter;
import net.datafaker.Hashing;
import net.datafaker.Hearthstone;
import net.datafaker.HeyArnold;
import net.datafaker.Hipster;
import net.datafaker.HitchhikersGuideToTheGalaxy;
import net.datafaker.Hobbit;
import net.datafaker.Hobby;
import net.datafaker.Horse;
import net.datafaker.HowIMetYourMother;
import net.datafaker.IdNumber;
import net.datafaker.Internet;
import net.datafaker.Job;
import net.datafaker.Kaamelott;
import net.datafaker.Kpop;
import net.datafaker.LeagueOfLegends;
import net.datafaker.Lebowski;
import net.datafaker.LordOfTheRings;
import net.datafaker.Lorem;
import net.datafaker.Marketing;
import net.datafaker.Matz;
import net.datafaker.Medical;
import net.datafaker.Military;
import net.datafaker.Minecraft;
import net.datafaker.Mood;
import net.datafaker.Mountain;
import net.datafaker.Mountaineering;
import net.datafaker.Music;
import net.datafaker.Name;
import net.datafaker.Nation;
import net.datafaker.NatoPhoneticAlphabet;
import net.datafaker.Nigeria;
import net.datafaker.Number;
import net.datafaker.Options;
import net.datafaker.OscarMovie;
import net.datafaker.Overwatch;
import net.datafaker.Passport;
import net.datafaker.PhoneNumber;
import net.datafaker.Photography;
import net.datafaker.Pokemon;
import net.datafaker.PrincessBride;
import net.datafaker.ProgrammingLanguage;
import net.datafaker.Relationship;
import net.datafaker.ResidentEvil;
import net.datafaker.Restaurant;
import net.datafaker.RickAndMorty;
import net.datafaker.Robin;
import net.datafaker.RockBand;
import net.datafaker.RuPaulDragRace;
import net.datafaker.Science;
import net.datafaker.Seinfeld;
import net.datafaker.Shakespeare;
import net.datafaker.Sip;
import net.datafaker.Size;
import net.datafaker.SlackEmoji;
import net.datafaker.SoulKnight;
import net.datafaker.Space;
import net.datafaker.StarCraft;
import net.datafaker.StarTrek;
import net.datafaker.Stock;
import net.datafaker.Subscription;
import net.datafaker.SuperMario;
import net.datafaker.Superhero;
import net.datafaker.Tea;
import net.datafaker.Team;
import net.datafaker.TheItCrowd;
import net.datafaker.Time;
import net.datafaker.Touhou;
import net.datafaker.Tron;
import net.datafaker.TwinPeaks;
import net.datafaker.Twitter;
import net.datafaker.University;
import net.datafaker.Vehicle;
import net.datafaker.Volleyball;
import net.datafaker.Weather;
import net.datafaker.Witcher;
import net.datafaker.Yoda;
import net.datafaker.Zelda;
import net.datafaker.fileformats.Json;
import net.datafaker.service.FakeValuesService;
import net.datafaker.service.RandomService;

public class Faker {
    private final RandomService randomService;
    private final FakeValuesService fakeValuesService;
    private final Map<Class<?>, Object> providersMap = new IdentityHashMap();

    public Faker() {
        this(Locale.ENGLISH);
    }

    public Faker(Locale locale) {
        this(locale, (Random)null);
    }

    public Faker(Random random) {
        this(Locale.ENGLISH, random);
    }

    public Faker(Locale locale, Random random) {
        this(locale, new RandomService(random));
    }

    public Faker(Locale locale, RandomService randomService) {
        this(new FakeValuesService(locale, randomService), randomService);
    }

    public Faker(FakeValuesService fakeValuesService, RandomService random) {
        this.randomService = random;
        this.fakeValuesService = fakeValuesService;
    }

    public static Faker instance() {
        return new Faker();
    }

    public static Faker instance(Locale locale) {
        return new Faker(locale);
    }

    public static Faker instance(Random random) {
        return new Faker(random);
    }

    public static Faker instance(Locale locale, Random random) {
        return new Faker(locale, random);
    }

    Locale getLocale() {
        return this.fakeValuesService.getLocalesChain().isEmpty() || this.fakeValuesService.getLocalesChain().get(0) == null ? Locale.ROOT : this.fakeValuesService.getLocalesChain().get(0);
    }

    public String numerify(String numberString) {
        return this.fakeValuesService.numerify(numberString);
    }

    public String letterify(String letterString) {
        return this.fakeValuesService.letterify(letterString);
    }

    public String letterify(String letterString, boolean isUpper) {
        return this.fakeValuesService.letterify(letterString, isUpper);
    }

    public String bothify(String string) {
        return this.fakeValuesService.bothify(string);
    }

    public String bothify(String string, boolean isUpper) {
        return this.fakeValuesService.bothify(string, isUpper);
    }

    public String regexify(String regex) {
        return this.fakeValuesService.regexify(regex);
    }

    public String examplify(String example) {
        return this.fakeValuesService.examplify(example);
    }

    public String templatify(String string, char char2replace, String ... options) {
        return this.fakeValuesService().templatify(string, char2replace, options);
    }

    public String templatify(String string, Map<Character, String[]> optionsMap) {
        return this.fakeValuesService().templatify(string, optionsMap);
    }

    public String csv(int limit, String ... columnExpressions) {
        return this.fakeValuesService().csv(limit, columnExpressions);
    }

    public String csv(String separator, char quote, boolean withHeader, int limit, String ... columnExpressions) {
        return this.fakeValuesService().csv(separator, quote, withHeader, limit, columnExpressions);
    }

    public Json json(String ... fieldExpressions) {
        return this.fakeValuesService().json(fieldExpressions);
    }

    public Json jsona(String ... fieldExpressions) {
        return this.fakeValuesService().jsona(fieldExpressions);
    }

    public RandomService random() {
        return this.randomService;
    }

    FakeValuesService fakeValuesService() {
        return this.fakeValuesService;
    }

    public void addPath(Locale locale, Path path) {
        this.fakeValuesService().addPath(locale, path);
    }

    protected <T> T getProvider(Class<T> clazz, Supplier<T> valueSupplier) {
        Object result = this.providersMap.get(clazz);
        if (result == null) {
            this.providersMap.putIfAbsent(clazz, valueSupplier.get());
            result = this.providersMap.get(clazz);
        }
        return (T)result;
    }

    public <T> FakeCollection.Builder<T> collection() {
        return new FakeCollection.Builder().faker(this);
    }

    public Address address() {
        return this.getProvider(Address.class, () -> new Address(this));
    }

    public Ancient ancient() {
        return this.getProvider(Ancient.class, () -> new Ancient(this));
    }

    public Animal animal() {
        return this.getProvider(Animal.class, () -> new Animal(this));
    }

    public App app() {
        return this.getProvider(App.class, () -> new App(this));
    }

    public Appliance appliance() {
        return this.getProvider(Appliance.class, () -> new Appliance(this));
    }

    public AquaTeenHungerForce aquaTeenHungerForce() {
        return this.getProvider(AquaTeenHungerForce.class, () -> new AquaTeenHungerForce(this));
    }

    public Artist artist() {
        return this.getProvider(Artist.class, () -> new Artist(this));
    }

    public Australia australia() {
        return this.getProvider(Australia.class, () -> new Australia(this));
    }

    public Avatar avatar() {
        return this.getProvider(Avatar.class, () -> new Avatar(this));
    }

    public Aviation aviation() {
        return this.getProvider(Aviation.class, () -> new Aviation(this));
    }

    public Aws aws() {
        return this.getProvider(Aws.class, () -> new Aws(this));
    }

    public BackToTheFuture backToTheFuture() {
        return this.getProvider(BackToTheFuture.class, () -> new BackToTheFuture(this));
    }

    public Babylon5 babylon5() {
        return this.getProvider(Babylon5.class, () -> new Babylon5(this));
    }

    public Barcode barcode() {
        return this.getProvider(Barcode.class, () -> new Barcode(this));
    }

    public Basketball basketball() {
        return this.getProvider(Basketball.class, () -> new Basketball(this));
    }

    public Battlefield1 battlefield1() {
        return this.getProvider(Battlefield1.class, () -> new Battlefield1(this));
    }

    public Beer beer() {
        return this.getProvider(Beer.class, () -> new Beer(this));
    }

    public BloodType bloodtype() {
        return this.getProvider(BloodType.class, () -> new BloodType(this));
    }

    public BojackHorseman bojackHorseman() {
        return this.getProvider(BojackHorseman.class, () -> new BojackHorseman(this));
    }

    public Book book() {
        return this.getProvider(Book.class, () -> new Book(this));
    }

    public Bool bool() {
        return this.getProvider(Bool.class, () -> new Bool(this));
    }

    public BossaNova bossaNova() {
        return this.getProvider(BossaNova.class, () -> new BossaNova(this));
    }

    public BreakingBad breakingBad() {
        return this.getProvider(BreakingBad.class, () -> new BreakingBad(this));
    }

    public BrooklynNineNine brooklynNineNine() {
        return this.getProvider(BrooklynNineNine.class, () -> new BrooklynNineNine(this));
    }

    public Buffy buffy() {
        return this.getProvider(Buffy.class, () -> new Buffy(this));
    }

    public Business business() {
        return this.getProvider(Business.class, () -> new Business(this));
    }

    public Camera camera() {
        return this.getProvider(Camera.class, () -> new Camera(this));
    }

    public Cat cat() {
        return this.getProvider(Cat.class, () -> new Cat(this));
    }

    public ChuckNorris chuckNorris() {
        return this.getProvider(ChuckNorris.class, () -> new ChuckNorris(this));
    }

    public CNPJ cnpj() {
        return this.getProvider(CNPJ.class, () -> new CNPJ(this));
    }

    public Code code() {
        return this.getProvider(Code.class, () -> new Code(this));
    }

    public Coin coin() {
        return this.getProvider(Coin.class, () -> new Coin(this));
    }

    public Color color() {
        return this.getProvider(Color.class, () -> new Color(this));
    }

    public Commerce commerce() {
        return this.getProvider(Commerce.class, () -> new Commerce(this));
    }

    public Company company() {
        return this.getProvider(Company.class, () -> new Company(this));
    }

    public Country country() {
        return this.getProvider(Country.class, () -> new Country(this));
    }

    public CPF cpf() {
        return this.getProvider(CPF.class, () -> new CPF(this));
    }

    public Hashing hashing() {
        return this.getProvider(Hashing.class, () -> new Hashing(this));
    }

    public CryptoCoin cryptoCoin() {
        return this.getProvider(CryptoCoin.class, () -> new CryptoCoin(this));
    }

    public Currency currency() {
        return this.getProvider(Currency.class, () -> new Currency(this));
    }

    public DateAndTime date() {
        return this.getProvider(DateAndTime.class, () -> new DateAndTime(this));
    }

    public Disease disease() {
        return this.getProvider(Disease.class, () -> new Disease(this));
    }

    public Demographic demographic() {
        return this.getProvider(Demographic.class, () -> new Demographic(this));
    }

    public Dessert dessert() {
        return this.getProvider(Dessert.class, () -> new Dessert(this));
    }

    public Device device() {
        return this.getProvider(Device.class, () -> new Device(this));
    }

    public Dog dog() {
        return this.getProvider(Dog.class, () -> new Dog(this));
    }

    public Domain domain() {
        return this.getProvider(Domain.class, () -> new Domain(this));
    }

    public DragonBall dragonBall() {
        return this.getProvider(DragonBall.class, () -> new DragonBall(this));
    }

    public Dune dune() {
        return this.getProvider(Dune.class, () -> new Dune(this));
    }

    public Educator educator() {
        return this.getProvider(Educator.class, () -> new Educator(this));
    }

    public EldenRing eldenRing() {
        return this.getProvider(EldenRing.class, () -> new EldenRing(this));
    }

    public ElderScrolls elderScrolls() {
        return this.getProvider(ElderScrolls.class, () -> new ElderScrolls(this));
    }

    public EnglandFootBall englandfootball() {
        return this.getProvider(EnglandFootBall.class, () -> new EnglandFootBall(this));
    }

    public ElectricalComponents electricalComponents() {
        return this.getProvider(ElectricalComponents.class, () -> new ElectricalComponents(this));
    }

    public Esports esports() {
        return this.getProvider(Esports.class, () -> new Esports(this));
    }

    public FakeDuration duration() {
        return this.getProvider(FakeDuration.class, () -> new FakeDuration(this));
    }

    public File file() {
        return this.getProvider(File.class, () -> new File(this));
    }

    public Finance finance() {
        return this.getProvider(Finance.class, () -> new Finance(this));
    }

    public Food food() {
        return this.getProvider(Food.class, () -> new Food(this));
    }

    public Formula1 formula1() {
        return this.getProvider(Formula1.class, () -> new Formula1(this));
    }

    public Friends friends() {
        return this.getProvider(Friends.class, () -> new Friends(this));
    }

    public FunnyName funnyName() {
        return this.getProvider(FunnyName.class, () -> new FunnyName(this));
    }

    public GameOfThrones gameOfThrones() {
        return this.getProvider(GameOfThrones.class, () -> new GameOfThrones(this));
    }

    public Gender gender() {
        return this.getProvider(Gender.class, () -> new Gender(this));
    }

    public GratefulDead gratefulDead() {
        return this.getProvider(GratefulDead.class, () -> new GratefulDead(this));
    }

    public Hacker hacker() {
        return this.getProvider(Hacker.class, () -> new Hacker(this));
    }

    public HarryPotter harryPotter() {
        return this.getProvider(HarryPotter.class, () -> new HarryPotter(this));
    }

    public Hearthstone hearthstone() {
        return this.getProvider(Hearthstone.class, () -> new Hearthstone(this));
    }

    public HeyArnold heyArnold() {
        return this.getProvider(HeyArnold.class, () -> new HeyArnold(this));
    }

    public Hipster hipster() {
        return this.getProvider(Hipster.class, () -> new Hipster(this));
    }

    public HitchhikersGuideToTheGalaxy hitchhikersGuideToTheGalaxy() {
        return this.getProvider(HitchhikersGuideToTheGalaxy.class, () -> new HitchhikersGuideToTheGalaxy(this));
    }

    public Hobbit hobbit() {
        return this.getProvider(Hobbit.class, () -> new Hobbit(this));
    }

    public Hobby hobby() {
        return this.getProvider(Hobby.class, () -> new Hobby(this));
    }

    public Horse horse() {
        return this.getProvider(Horse.class, () -> new Horse(this));
    }

    public HowIMetYourMother howIMetYourMother() {
        return this.getProvider(HowIMetYourMother.class, () -> new HowIMetYourMother(this));
    }

    public IdNumber idNumber() {
        return this.getProvider(IdNumber.class, () -> new IdNumber(this));
    }

    public Internet internet() {
        return this.getProvider(Internet.class, () -> new Internet(this));
    }

    public Job job() {
        return this.getProvider(Job.class, () -> new Job(this));
    }

    public Kaamelott kaamelott() {
        return this.getProvider(Kaamelott.class, () -> new Kaamelott(this));
    }

    public Kpop kpop() {
        return this.getProvider(Kpop.class, () -> new Kpop(this));
    }

    public Lebowski lebowski() {
        return this.getProvider(Lebowski.class, () -> new Lebowski(this));
    }

    public LeagueOfLegends leagueOfLegends() {
        return this.getProvider(LeagueOfLegends.class, () -> new LeagueOfLegends(this));
    }

    public LordOfTheRings lordOfTheRings() {
        return this.getProvider(LordOfTheRings.class, () -> new LordOfTheRings(this));
    }

    public Lorem lorem() {
        return this.getProvider(Lorem.class, () -> new Lorem(this));
    }

    public Marketing marketing() {
        return this.getProvider(Marketing.class, () -> new Marketing(this));
    }

    public Matz matz() {
        return this.getProvider(Matz.class, () -> new Matz(this));
    }

    public Medical medical() {
        return this.getProvider(Medical.class, () -> new Medical(this));
    }

    public Military military() {
        return this.getProvider(Military.class, () -> new Military(this));
    }

    public Minecraft minecraft() {
        return this.getProvider(Minecraft.class, () -> new Minecraft(this));
    }

    public Mood mood() {
        return this.getProvider(Mood.class, () -> new Mood(this));
    }

    public Mountain mountain() {
        return this.getProvider(Mountain.class, () -> new Mountain(this));
    }

    public Mountaineering mountaineering() {
        return this.getProvider(Mountaineering.class, () -> new Mountaineering(this));
    }

    public Music music() {
        return this.getProvider(Music.class, () -> new Music(this));
    }

    public Name name() {
        return this.getProvider(Name.class, () -> new Name(this));
    }

    public Nation nation() {
        return this.getProvider(Nation.class, () -> new Nation(this));
    }

    public NatoPhoneticAlphabet natoPhoneticAlphabet() {
        return this.getProvider(NatoPhoneticAlphabet.class, () -> new NatoPhoneticAlphabet(this));
    }

    public Nigeria nigeria() {
        return this.getProvider(Nigeria.class, () -> new Nigeria(this));
    }

    public Number number() {
        return this.getProvider(Number.class, () -> new Number(this));
    }

    public Options options() {
        return this.getProvider(Options.class, () -> new Options(this));
    }

    public Overwatch overwatch() {
        return this.getProvider(Overwatch.class, () -> new Overwatch(this));
    }

    public OscarMovie oscarMovie() {
        return this.getProvider(OscarMovie.class, () -> new OscarMovie(this));
    }

    public Passport passport() {
        return this.getProvider(Passport.class, () -> new Passport(this));
    }

    public PhoneNumber phoneNumber() {
        return this.getProvider(PhoneNumber.class, () -> new PhoneNumber(this));
    }

    public Photography photography() {
        return this.getProvider(Photography.class, () -> new Photography(this));
    }

    public Pokemon pokemon() {
        return this.getProvider(Pokemon.class, () -> new Pokemon(this));
    }

    public PrincessBride princessBride() {
        return this.getProvider(PrincessBride.class, () -> new PrincessBride(this));
    }

    public ProgrammingLanguage programmingLanguage() {
        return this.getProvider(ProgrammingLanguage.class, () -> new ProgrammingLanguage(this));
    }

    public Relationship relationships() {
        return this.getProvider(Relationship.class, () -> new Relationship(this));
    }

    public ResidentEvil residentEvil() {
        return this.getProvider(ResidentEvil.class, () -> new ResidentEvil(this));
    }

    public Restaurant restaurant() {
        return this.getProvider(Restaurant.class, () -> new Restaurant(this));
    }

    public RickAndMorty rickAndMorty() {
        return this.getProvider(RickAndMorty.class, () -> new RickAndMorty(this));
    }

    public Robin robin() {
        return this.getProvider(Robin.class, () -> new Robin(this));
    }

    public RockBand rockBand() {
        return this.getProvider(RockBand.class, () -> new RockBand(this));
    }

    public RuPaulDragRace ruPaulDragRace() {
        return this.getProvider(RuPaulDragRace.class, () -> new RuPaulDragRace(this));
    }

    public Science science() {
        return this.getProvider(Science.class, () -> new Science(this));
    }

    public Seinfeld seinfeld() {
        return this.getProvider(Seinfeld.class, () -> new Seinfeld(this));
    }

    public SlackEmoji slackEmoji() {
        return this.getProvider(SlackEmoji.class, () -> new SlackEmoji(this));
    }

    public Shakespeare shakespeare() {
        return this.getProvider(Shakespeare.class, () -> new Shakespeare(this));
    }

    public Sip sip() {
        return this.getProvider(Sip.class, () -> new Sip(this));
    }

    public Size size() {
        return this.getProvider(Size.class, () -> new Size(this));
    }

    public SoulKnight soulKnight() {
        return this.getProvider(SoulKnight.class, () -> new SoulKnight(this));
    }

    public Space space() {
        return this.getProvider(Space.class, () -> new Space(this));
    }

    public StarCraft starCraft() {
        return this.getProvider(StarCraft.class, () -> new StarCraft(this));
    }

    public StarTrek starTrek() {
        return this.getProvider(StarTrek.class, () -> new StarTrek(this));
    }

    public Stock stock() {
        return this.getProvider(Stock.class, () -> new Stock(this));
    }

    public Subscription subscription() {
        return this.getProvider(Subscription.class, () -> new Subscription(this));
    }

    public Superhero superhero() {
        return this.getProvider(Superhero.class, () -> new Superhero(this));
    }

    public SuperMario superMario() {
        return this.getProvider(SuperMario.class, () -> new SuperMario(this));
    }

    public Tea tea() {
        return this.getProvider(Tea.class, () -> new Tea(this));
    }

    public Team team() {
        return this.getProvider(Team.class, () -> new Team(this));
    }

    public TheItCrowd theItCrowd() {
        return this.getProvider(TheItCrowd.class, () -> new TheItCrowd(this));
    }

    public Time time() {
        return this.getProvider(Time.class, () -> new Time(this));
    }

    public Touhou touhou() {
        return this.getProvider(Touhou.class, () -> new Touhou(this));
    }

    public Tron tron() {
        return this.getProvider(Tron.class, () -> new Tron(this));
    }

    public TwinPeaks twinPeaks() {
        return this.getProvider(TwinPeaks.class, () -> new TwinPeaks(this));
    }

    public Twitter twitter() {
        return this.getProvider(Twitter.class, () -> new Twitter(this));
    }

    public University university() {
        return this.getProvider(University.class, () -> new University(this));
    }

    public Vehicle vehicle() {
        return this.getProvider(Vehicle.class, () -> new Vehicle(this));
    }

    public Volleyball volleyball() {
        return this.getProvider(Volleyball.class, () -> new Volleyball(this));
    }

    public Weather weather() {
        return this.getProvider(Weather.class, () -> new Weather(this));
    }

    public Witcher witcher() {
        return this.getProvider(Witcher.class, () -> new Witcher(this));
    }

    public Yoda yoda() {
        return this.getProvider(Yoda.class, () -> new Yoda(this));
    }

    public Zelda zelda() {
        return this.getProvider(Zelda.class, () -> new Zelda(this));
    }

    public String resolve(String key) {
        return this.fakeValuesService.resolve(key, this, this);
    }

    public String expression(String expression) {
        return this.fakeValuesService.expression(expression, this);
    }
}

