/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.time.LocalDate;
import java.time.ZoneId;
import net.datafaker.Faker;
import net.datafaker.idnumbers.EnIdNumber;
import net.datafaker.idnumbers.EnZAIdNumber;
import net.datafaker.idnumbers.EsMXIdNumber;
import net.datafaker.idnumbers.NricNumber;
import net.datafaker.idnumbers.PeselNumber;
import net.datafaker.idnumbers.PtNifIdNumber;
import net.datafaker.idnumbers.SvSEIdNumber;
import net.datafaker.idnumbers.ZhCnIdNumber;

public class IdNumber {
    private final Faker faker;

    protected IdNumber(Faker faker) {
        this.faker = faker;
    }

    public String valid() {
        return this.faker.fakeValuesService().resolve("id_number.valid", this, this.faker);
    }

    public String invalid() {
        return this.faker.numerify(this.faker.fakeValuesService().resolve("id_number.invalid", this, this.faker));
    }

    public String ssnValid() {
        EnIdNumber enIdNumber = new EnIdNumber();
        return enIdNumber.getValidSsn(this.faker);
    }

    public String validSvSeSsn() {
        SvSEIdNumber svSEIdNumber = new SvSEIdNumber();
        return svSEIdNumber.getValidSsn(this.faker);
    }

    public String validEnZaSsn() {
        EnZAIdNumber enZAIdNumber = new EnZAIdNumber();
        return enZAIdNumber.getValidSsn(this.faker);
    }

    public String inValidEnZaSsn() {
        EnZAIdNumber enZAIdNumber = new EnZAIdNumber();
        return enZAIdNumber.getInValidSsn(this.faker);
    }

    public String invalidSvSeSsn() {
        SvSEIdNumber svSEIdNumber = new SvSEIdNumber();
        return svSEIdNumber.getInvalidSsn(this.faker);
    }

    public String singaporeanFin() {
        return NricNumber.getValidFIN(this.faker, NricNumber.Type.FOREIGNER_TWENTY_FIRST_CENTURY);
    }

    public String singaporeanFinBefore2000() {
        return NricNumber.getValidFIN(this.faker, NricNumber.Type.FOREIGNER_TWENTIETH_CENTURY);
    }

    public String singaporeanUin() {
        return NricNumber.getValidFIN(this.faker, NricNumber.Type.SINGAPOREAN_TWENTY_FIRST_CENTURY);
    }

    public String singaporeanUinBefore2000() {
        return NricNumber.getValidFIN(this.faker, NricNumber.Type.SINGAPOREAN_TWENTIETH_CENTURY);
    }

    public String validZhCNSsn() {
        ZhCnIdNumber zhCnIdNumber = new ZhCnIdNumber();
        return zhCnIdNumber.getValidSsn(this.faker);
    }

    public String validPtNif() {
        PtNifIdNumber idNumber = new PtNifIdNumber();
        return idNumber.getValid(this.faker);
    }

    public String invalidPtNif() {
        PtNifIdNumber idNumber = new PtNifIdNumber();
        return idNumber.getInvalid(this.faker);
    }

    public String validEsMXSsn() {
        EsMXIdNumber esMXIdNumber = new EsMXIdNumber();
        return esMXIdNumber.get(this.faker);
    }

    public String invalidEsMXSsn() {
        EsMXIdNumber esMXIdNumber = new EsMXIdNumber();
        return esMXIdNumber.getWrong(this.faker);
    }

    public String peselNumber() {
        return this.peselNumber(this.faker.date().birthday(0, 100).toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), PeselNumber.Gender.ANY);
    }

    public String peselNumber(LocalDate birthDate, PeselNumber.Gender gender) {
        return new PeselNumber(this.faker).get(birthDate, gender);
    }
}

