/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.datafaker.Faker;
import net.datafaker.service.FakerIDN;
import net.datafaker.service.RandomService;

public class Internet {
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final Pattern COLON = Pattern.compile(":");
    private final Faker faker;
    public static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

    protected Internet(Faker faker) {
        this.faker = faker;
    }

    public String emailAddress() {
        return this.emailAddress(this.faker.name().username());
    }

    public String emailAddress(String localPart) {
        return this.emailAddress(localPart, FakerIDN.toASCII(this.faker.fakeValuesService().resolve("internet.free_email", this, this.faker)));
    }

    public String safeEmailAddress() {
        return this.safeEmailAddress(this.faker.name().username());
    }

    public String safeEmailAddress(String localPart) {
        return this.emailAddress(localPart, FakerIDN.toASCII(this.faker.fakeValuesService().resolve("internet.safe_email", this, this.faker)));
    }

    private String emailAddress(String localPart, String domain) {
        return String.join((CharSequence)"", this.stripAccents(localPart), "@", domain);
    }

    private String stripAccents(String input) {
        String str = Normalizer.normalize(input, Normalizer.Form.NFD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }

    public String domainName() {
        return this.domainWord() + "." + this.domainSuffix();
    }

    public String domainWord() {
        return FakerIDN.toASCII(SINGLE_QUOTE.matcher(this.faker.name().lastName().toLowerCase()).replaceAll(""));
    }

    public String domainSuffix() {
        return this.faker.fakeValuesService().resolve("internet.domain_suffix", this, this.faker);
    }

    public String url() {
        return String.join((CharSequence)"", "www", ".", FakerIDN.toASCII(SINGLE_QUOTE.matcher(this.faker.name().firstName().toLowerCase()).replaceAll("") + "-" + this.domainWord()), ".", this.domainSuffix());
    }

    public String avatar() {
        return "https://s3.amazonaws.com/uifaces/faces/twitter/" + this.faker.fakeValuesService().resolve("internet.avatar", this, this.faker);
    }

    public String image() {
        String[] dimension = this.faker.fakeValuesService().resolve("internet.image_dimension", this, this.faker).split("x");
        if (dimension.length == 0) {
            return "";
        }
        return this.image(Integer.valueOf(dimension[0].trim()), Integer.valueOf(dimension[1].trim()), this.faker.bool().bool(), null);
    }

    public String image(Integer width, Integer height, Boolean gray, String text) {
        return String.format("https://lorempixel.com/%s%s/%s/%s/%s", gray != false ? "g/" : "", width, height, this.faker.fakeValuesService().resolve("internet.image_category", this, this.faker), text == null || text.length() == 0 ? "" : text);
    }

    public String password() {
        return this.password(8, 16);
    }

    public String password(boolean includeDigit) {
        return this.password(8, 16, false, false, includeDigit);
    }

    public String password(int minimumLength, int maximumLength) {
        return this.password(minimumLength, maximumLength, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.password(minimumLength, maximumLength, includeUppercase, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial) {
        return this.password(minimumLength, maximumLength, includeUppercase, includeSpecial, true);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial, boolean includeDigit) {
        return this.faker.lorem().characters(minimumLength, maximumLength, includeUppercase, includeSpecial, includeDigit);
    }

    public String macAddress(String prefix) {
        String tmp = prefix == null ? "" : prefix;
        int prefixLength = tmp.trim().length() == 0 ? 0 : COLON.split(tmp).length;
        StringBuilder out = new StringBuilder(tmp);
        for (int i = 0; i < 6 - prefixLength; ++i) {
            if (out.length() > 0) {
                out.append(':');
            }
            out.append(Integer.toHexString(this.faker.random().nextInt(16)));
            out.append(Integer.toHexString(this.faker.random().nextInt(16)));
        }
        return out.toString();
    }

    public String macAddress() {
        return this.macAddress("");
    }

    public String ipV4Address() {
        try {
            return this.getIpV4Address().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public InetAddress getIpV4Address() throws UnknownHostException {
        return Inet4Address.getByAddress(new byte[]{(byte)(this.faker.random().nextInt(254) + 2), (byte)(this.faker.random().nextInt(254) + 2), (byte)(this.faker.random().nextInt(254) + 2), (byte)(this.faker.random().nextInt(254) + 2)});
    }

    public String privateIpV4Address() {
        try {
            return this.getPrivateIpV4Address().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public InetAddress getPrivateIpV4Address() throws UnknownHostException {
        Byte[] PRIVATE_FIRST_OCTET = new Byte[]{(byte)10, (byte)127, (byte)-87, (byte)-64, (byte)-84};
        Byte[] PRIVATE_SECOND_OCTET_172 = new Byte[]{(byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)21, (byte)22, (byte)23, (byte)24, (byte)25, (byte)26, (byte)27, (byte)28, (byte)29, (byte)30, (byte)31};
        RandomService r = this.faker.random();
        byte first = this.random(PRIVATE_FIRST_OCTET);
        byte second = (byte)r.nextInt(256);
        byte third = (byte)r.nextInt(256);
        byte fourth = (byte)r.nextInt(256);
        switch (first) {
            case -84: {
                second = this.random(PRIVATE_SECOND_OCTET_172);
                break;
            }
            case -64: {
                second = -88;
                break;
            }
            case -87: {
                second = -2;
            }
        }
        return Inet4Address.getByAddress(new byte[]{first, second, third, fourth});
    }

    public String publicIpV4Address() {
        try {
            return this.getPublicIpV4Address().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public InetAddress getPublicIpV4Address() throws UnknownHostException {
        RandomService r = this.faker.random();
        byte[] PRIVATE_FIRST_OCTET = new byte[]{10, 127, -87, -64, -84};
        byte first = (byte)r.nextInt(256);
        byte second = (byte)r.nextInt(256);
        byte third = (byte)r.nextInt(256);
        byte fourth = (byte)r.nextInt(256);
        while (Arrays.binarySearch(PRIVATE_FIRST_OCTET, first) > 0) {
            first = (byte)r.nextInt(256);
        }
        return Inet4Address.getByAddress(new byte[]{first, second, third, fourth});
    }

    public String ipV4Cidr() {
        return this.ipV4Address() + '/' + (this.faker.random().nextInt(31) + 1);
    }

    public String ipV6Address() {
        try {
            return this.getIpV6Address().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "0:0:0:0:0:0:0:1";
        }
    }

    public InetAddress getIpV6Address() throws UnknownHostException {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            if (i > 0) {
                tmp.append(":");
            }
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
            tmp.append(Integer.toHexString(this.faker.random().nextInt(16)));
        }
        return Inet6Address.getByName(tmp.toString());
    }

    public String ipV6Cidr() {
        return this.ipV6Address() + '/' + (this.faker.random().nextInt(127) + 1);
    }

    public String slug() {
        return this.slug(this.faker.lorem().words(2), "_");
    }

    public String slug(List<String> wordsOrNull, String glueOrNull) {
        String glue = glueOrNull == null ? "_" : glueOrNull;
        List<String> words = wordsOrNull == null ? this.faker.lorem().words(2) : wordsOrNull;
        StringBuilder slug = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            if (i > 0) {
                slug.append(glue);
            }
            slug.append(words.get(i));
        }
        return slug.toString();
    }

    public String uuid() {
        return UUID.randomUUID().toString();
    }

    private <T> T random(T[] src) {
        return src[this.faker.random().nextInt(src.length)];
    }

    public String userAgent(UserAgent userAgent) {
        UserAgent agent = userAgent;
        if (agent == null) {
            agent = UserAgent.any(this.faker);
        }
        String userAgentKey = "internet.user_agent." + agent.toString();
        return this.faker.fakeValuesService().resolve(userAgentKey, this, this.faker);
    }

    public String userAgentAny() {
        return this.userAgent(null);
    }

    public static enum UserAgent {
        AOL("aol"),
        CHROME("chrome"),
        FIREFOX("firefox"),
        INTERNET_EXPLORER("internet_explorer"),
        NETSCAPE("netscape"),
        OPERA("opera"),
        SAFARI("safari");

        private final String browserName;

        private UserAgent(String browserName) {
            this.browserName = browserName;
        }

        private static UserAgent any(Faker faker) {
            UserAgent[] agents = UserAgent.values();
            int randomIndex = (int)(faker.random().nextDouble() * (double)agents.length);
            return agents[randomIndex];
        }

        public String toString() {
            return this.browserName;
        }
    }
}

