/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.datafaker.Faker;

public class Lorem {
    private final Faker faker;
    private static final char[] letters;
    private static final char[] characters;

    protected Lorem(Faker faker) {
        this.faker = faker;
    }

    public char character() {
        return this.character(false);
    }

    public char character(boolean includeUppercase) {
        return this.characters(1, includeUppercase).charAt(0);
    }

    public String characters() {
        return this.characters(255, false);
    }

    public String characters(boolean includeUppercase) {
        return this.characters(255, includeUppercase);
    }

    public String characters(int minimumLength, int maximumLength) {
        return this.characters((int)this.faker.random().nextInt(minimumLength, maximumLength), false);
    }

    public String characters(int minimumLength, int maximumLength, boolean includeUppercase) {
        if (minimumLength == maximumLength) {
            return this.characters(minimumLength, includeUppercase);
        }
        return this.characters((int)this.faker.random().nextInt(minimumLength, maximumLength), includeUppercase);
    }

    public String characters(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeDigit) {
        if (minimumLength == maximumLength) {
            return this.characters(minimumLength, includeUppercase, includeDigit);
        }
        return this.characters((int)this.faker.random().nextInt(minimumLength, maximumLength), includeUppercase, includeDigit);
    }

    public String characters(int fixedNumberOfCharacters) {
        return this.characters(fixedNumberOfCharacters, false);
    }

    public String characters(int fixedNumberOfCharacters, boolean includeUppercase) {
        return this.characters(fixedNumberOfCharacters, includeUppercase, true);
    }

    public String characters(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial, boolean includeDigit) {
        return this.characters((int)this.faker.random().nextInt(minimumLength, maximumLength), includeUppercase, includeSpecial, includeDigit);
    }

    public String characters(int fixedNumberOfCharacters, boolean includeUppercase, boolean includeDigit) {
        if (fixedNumberOfCharacters < 1) {
            return "";
        }
        char[] buffer = new char[fixedNumberOfCharacters];
        for (int i = 0; i < buffer.length; ++i) {
            char randomCharacter = includeDigit ? characters[this.faker.random().nextInt(characters.length)] : letters[this.faker.random().nextInt(letters.length)];
            if (includeUppercase && this.faker.bool().bool()) {
                randomCharacter = Character.toUpperCase(randomCharacter);
            }
            buffer[i] = randomCharacter;
        }
        return new String(buffer);
    }

    public String characters(int fixedNumberOfCharacters, boolean includeUppercase, boolean includeSpecial, boolean includeDigit) {
        if (fixedNumberOfCharacters < 1) {
            return "";
        }
        char[] buffer = new char[fixedNumberOfCharacters];
        char[] special = new char[]{'!', '@', '#', '$', '%', '^', '&', '*'};
        char[] number = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        char[] all = new char[special.length + characters.length];
        System.arraycopy(special, 0, all, 0, special.length);
        System.arraycopy(characters, 0, all, special.length, characters.length);
        char[] specialAndLetter = new char[special.length + letters.length];
        System.arraycopy(special, 0, specialAndLetter, 0, special.length);
        System.arraycopy(letters, 0, specialAndLetter, special.length, letters.length);
        int cnt = 0;
        if (includeUppercase) {
            char theUpper = Character.toUpperCase(letters[this.faker.random().nextInt(letters.length)]);
            buffer[cnt++] = theUpper;
        }
        if (includeSpecial) {
            char theSpecial = special[this.faker.random().nextInt(special.length)];
            if (cnt > fixedNumberOfCharacters - 1) {
                return "";
            }
            buffer[cnt++] = theSpecial;
        }
        if (includeDigit) {
            char theNum = number[this.faker.random().nextInt(number.length)];
            if (cnt > fixedNumberOfCharacters - 1) {
                return "";
            }
            buffer[cnt++] = theNum;
        }
        for (int i = cnt; i < buffer.length; ++i) {
            char randomCharacter = includeSpecial && !includeDigit ? specialAndLetter[this.faker.random().nextInt(specialAndLetter.length)] : (!includeSpecial && includeDigit ? characters[this.faker.random().nextInt(characters.length)] : (!includeSpecial ? letters[this.faker.random().nextInt(letters.length)] : all[this.faker.random().nextInt(all.length)]));
            if (includeUppercase && this.faker.bool().bool()) {
                randomCharacter = Character.toUpperCase(randomCharacter);
            }
            buffer[i] = randomCharacter;
        }
        this.shuffle(buffer);
        return String.valueOf(buffer);
    }

    private void shuffle(char[] buffer) {
        int length;
        for (int i = length = buffer.length; i > 0; --i) {
            int randInd = this.faker.random().nextInt(i);
            this.swap(buffer, randInd, i - 1);
        }
    }

    private void swap(char[] a, int i, int j) {
        char temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public List<String> words(int num) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            returnList.add(this.word());
        }
        return returnList;
    }

    public List<String> words() {
        return this.words(3);
    }

    public String word() {
        return this.faker.fakeValuesService().resolve("lorem.words", this, this.faker);
    }

    public String sentence() {
        return this.sentence(3);
    }

    public String sentence(int wordCount) {
        return this.sentence(wordCount, 6);
    }

    public String sentence(int wordCount, int randomWordsToAdd) {
        int numberOfWordsToAdd = randomWordsToAdd == 0 ? 0 : this.faker.random().nextInt(randomWordsToAdd);
        return Lorem.capitalize(String.join((CharSequence)" ", this.words(wordCount + numberOfWordsToAdd)) + ".");
    }

    private static String capitalize(String input) {
        if (input == null) {
            return null;
        }
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    public List<String> sentences(int sentenceCount) {
        ArrayList<String> sentences = new ArrayList<String>(sentenceCount);
        for (int i = 0; i < sentenceCount; ++i) {
            sentences.add(this.sentence());
        }
        return sentences;
    }

    public String paragraph(int sentenceCount) {
        return String.join((CharSequence)" ", this.sentences(sentenceCount + this.faker.random().nextInt(3)));
    }

    public String paragraph() {
        return this.paragraph(3);
    }

    public List<String> paragraphs(int paragraphCount) {
        ArrayList<String> paragraphs = new ArrayList<String>(paragraphCount);
        for (int i = 0; i < paragraphCount; ++i) {
            paragraphs.add(this.paragraph());
        }
        return paragraphs;
    }

    public String fixedString(int numberOfLetters) {
        if (numberOfLetters <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        while (builder.length() < numberOfLetters) {
            builder.append(this.sentence());
        }
        return builder.substring(0, numberOfLetters);
    }

    public String maxLengthSentence(int fixedLength) {
        if (fixedLength <= 0) {
            return "";
        }
        String sentence = this.sentence(fixedLength);
        String endOfSentence = sentence.substring(fixedLength - 1, fixedLength);
        while (" ".equals(endOfSentence)) {
            sentence = this.sentence(fixedLength);
            endOfSentence = sentence.substring(fixedLength - 1, fixedLength);
        }
        return sentence.substring(0, fixedLength);
    }

    static {
        StringBuilder builder = new StringBuilder(36);
        for (char character = 'a'; character <= 'z'; character = (char)(character + '\u0001')) {
            builder.append(character);
        }
        letters = builder.toString().toCharArray();
        for (char number = '0'; number <= '9'; number = (char)(number + '\u0001')) {
            builder.append(number);
        }
        characters = builder.toString().toCharArray();
    }
}

