/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.util.Locale;
import java.util.regex.Pattern;
import net.datafaker.Faker;

public class Name {
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private final Faker faker;

    protected Name(Faker faker) {
        this.faker = faker;
    }

    public String name() {
        return this.faker.fakeValuesService().resolve("name.name", this, this.faker);
    }

    public String nameWithMiddle() {
        return this.faker.fakeValuesService().resolve("name.name_with_middle", this, this.faker);
    }

    public String fullName() {
        return this.name();
    }

    public String firstName() {
        return this.faker.fakeValuesService().resolve("name.first_name", this, this.faker);
    }

    public String lastName() {
        return this.faker.fakeValuesService().resolve("name.last_name", this, this.faker);
    }

    public String prefix() {
        return this.faker.fakeValuesService().resolve("name.prefix", this, this.faker);
    }

    public String suffix() {
        return this.faker.fakeValuesService().resolve("name.suffix", this, this.faker);
    }

    public String title() {
        return String.join((CharSequence)" ", this.faker.fakeValuesService().resolve("name.title.descriptor", this, this.faker), this.faker.fakeValuesService().resolve("name.title.level", this, this.faker), this.faker.fakeValuesService().resolve("name.title.job", this, this.faker));
    }

    public String username() {
        String username = String.join((CharSequence)"", SINGLE_QUOTE.matcher(this.firstName()).replaceAll("").toLowerCase(Locale.ROOT), ".", SINGLE_QUOTE.matcher(this.lastName()).replaceAll("").toLowerCase(Locale.ROOT));
        return username.replaceAll("\\s+", "");
    }

    public String bloodGroup() {
        return this.faker.fakeValuesService().resolve("name.blood_group", this, this.faker);
    }
}

