/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import net.datafaker.Faker;

public class Nation {
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private final Faker faker;

    protected Nation(Faker faker) {
        this.faker = faker;
    }

    public String nationality() {
        return this.faker.fakeValuesService().resolve("nation.nationality", this, this.faker);
    }

    public String language() {
        return this.faker.fakeValuesService().resolve("nation.language", this, this.faker);
    }

    public String capitalCity() {
        return this.faker.fakeValuesService().resolve("nation.capital_city", this, this.faker);
    }

    public String flag() {
        List flagInts = (List)this.faker.fakeValuesService().fetch("nation.flag");
        ByteBuffer byteBuffer = MappedByteBuffer.allocate(flagInts.size());
        for (Integer flagInt : flagInts) {
            byteBuffer.put(flagInt.byteValue());
        }
        return new String(byteBuffer.array(), UTF8_CHARSET);
    }

    public String isoLanguage() {
        String[] isoLangs = Locale.getISOLanguages();
        return isoLangs[this.faker.random().nextInt(isoLangs.length)];
    }

    public String isoCountry() {
        String[] isoCountries = Locale.getISOCountries();
        return isoCountries[this.faker.random().nextInt(isoCountries.length)];
    }
}

