/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.datafaker.Faker;

public class Number {
    private final Faker faker;

    protected Number(Faker faker) {
        this.faker = faker;
    }

    public int randomDigit() {
        return this.decimalBetween(0L, 10L).intValue();
    }

    public int randomDigitNotZero() {
        return this.decimalBetween(1L, 10L).intValue();
    }

    public int positive() {
        return this.decimalBetween(1L, Integer.MAX_VALUE).intValue();
    }

    public int negative() {
        return this.decimalBetween(0L, Integer.MIN_VALUE).intValue();
    }

    public int numberBetween(int min, int max) {
        if (min == max) {
            return min;
        }
        return this.decimalBetween(min, max).intValue();
    }

    public long numberBetween(long min, long max) {
        if (min == max) {
            return min;
        }
        return this.decimalBetween(min, max).longValue();
    }

    public long randomNumber(int numberOfDigits, boolean strict) {
        long max = (long)Math.pow(10.0, numberOfDigits);
        if (strict) {
            long min = (long)Math.pow(10.0, numberOfDigits - 1);
            return this.faker.random().nextLong(max - min) + min;
        }
        return this.faker.random().nextLong(max);
    }

    public long randomNumber() {
        int numberOfDigits = this.decimalBetween(1L, 10L).intValue();
        return this.randomNumber(numberOfDigits, false);
    }

    public double randomDouble(int maxNumberOfDecimals, int min, int max) {
        return this.randomDouble(maxNumberOfDecimals, (long)min, (long)max);
    }

    public double randomDouble(int maxNumberOfDecimals, long min, long max) {
        return this.decimalBetween(min, max).setScale(maxNumberOfDecimals, RoundingMode.HALF_DOWN).doubleValue();
    }

    private BigDecimal decimalBetween(long min, long max) {
        if (min == max) {
            return BigDecimal.valueOf(min);
        }
        BigDecimal trueMin = BigDecimal.valueOf(min);
        BigDecimal trueMax = BigDecimal.valueOf(max);
        BigDecimal random = BigDecimal.valueOf(this.faker.random().nextDouble());
        return trueMin.add(trueMax.subtract(trueMin).multiply(random));
    }

    public String digits(int count) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            tmp.append(this.randomDigit());
        }
        return tmp.toString();
    }

    public String digit() {
        return this.digits(1);
    }
}

