/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.datafaker.Faker;

public class Options {
    private final Faker faker;

    protected Options(Faker faker) {
        this.faker = faker;
    }

    @SafeVarargs
    public final <E> E option(E ... options) {
        return options[this.faker.random().nextInt(options.length)];
    }

    public final <E> Set<E> subset(int size, E ... options) {
        if (size < 0) {
            throw new IllegalArgumentException("size should be not negative");
        }
        if (size == 0) {
            return Collections.emptySet();
        }
        List opts = Stream.of(options).distinct().collect(Collectors.toList());
        if (size >= opts.size()) {
            return new HashSet(opts);
        }
        HashSet set = new HashSet();
        for (int i = 0; i < size; ++i) {
            int randomIndex = this.faker.random().nextInt(opts.size());
            set.add(opts.get(randomIndex));
            opts.remove(randomIndex);
        }
        return set;
    }

    public String option(String ... options) {
        return options[this.faker.random().nextInt(options.length)];
    }

    public final Set<String> subset(int size, String ... options) {
        if (size < 0) {
            throw new IllegalArgumentException("size should be not negative");
        }
        if (size == 0) {
            return Collections.emptySet();
        }
        List opts = Stream.of(options).distinct().collect(Collectors.toList());
        if (size >= opts.size()) {
            return new HashSet<String>(opts);
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            int randomIndex = this.faker.random().nextInt(opts.size());
            set.add((String)opts.get(randomIndex));
            opts.remove(randomIndex);
        }
        return set;
    }

    public <E extends Enum<E>> E option(Class<E> enumeration) {
        Enum[] enumConstants = (Enum[])enumeration.getEnumConstants();
        return (E)enumConstants[this.faker.random().nextInt(enumConstants.length)];
    }

    public <E> E nextElement(E[] array) {
        return array[this.faker.random().nextInt(array.length)];
    }

    public <E> E nextElement(List<E> list) {
        return list.get(this.faker.random().nextInt(list.size()));
    }
}

