/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import net.datafaker.Faker;

public class Relationship {
    private final Faker faker;

    protected Relationship(Faker faker) {
        this.faker = faker;
    }

    public String direct() {
        return this.faker.resolve("relationship.familial.direct");
    }

    public String extended() {
        return this.faker.resolve("relationship.familial.extended");
    }

    public String inLaw() {
        return this.faker.resolve("relationship.in_law");
    }

    public String spouse() {
        return this.faker.resolve("relationship.spouse");
    }

    public String parent() {
        return this.faker.resolve("relationship.parent");
    }

    public String sibling() {
        return this.faker.resolve("relationship.sibling");
    }

    public String any() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String currentMethodName = stackTrace[1].getMethodName();
        try {
            Method[] methods = (Method[])Arrays.stream(Relationship.class.getDeclaredMethods()).filter(declaredMethod -> !declaredMethod.getName().equals(currentMethodName) && Modifier.isPublic(declaredMethod.getModifiers())).toArray(Method[]::new);
            int indx = this.faker.random().nextInt(methods.length);
            Method runMethod = methods[indx];
            Relationship relationship = new Relationship(this.faker);
            return (String)runMethod.invoke((Object)relationship, new Object[0]);
        }
        catch (SecurityException e) {
            throw new SecurityException("SecurityException: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("IllegalArgumentException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException: " + e.getMessage());
        }
    }
}

